/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import java.io.File;
import java.net.URI;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.ontology.records.SesameRecordHelper;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.SimplePipelet;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;

public class CreateFileUriPipelet
implements SimplePipelet {
    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                Id id = idArray[n2];
                String filename = id.getKey().getKey().replace('\\', '/');
                try {
                    File file = new File(filename);
                    URI fileUri = file.toURI();
                    Literal uriLiteral = blackboard.createLiteral(id);
                    uriLiteral.setStringValue(fileUri.toString());
                    uriLiteral.setSemanticType("rdfs:Resource");
                    blackboard.setLiteral(id, SesameRecordHelper.PATH_URI, uriLiteral);
                }
                catch (Exception ex) {
                    throw new ProcessingException("error creating file URI from key " + filename, (Throwable)ex);
                }
                ++n2;
            }
        }
        return recordIds;
    }

    public void configure(PipeletConfiguration configuration) throws ProcessingException {
    }
}

