/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import java.util.List;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.ontology.pipelets.ASesameRecordPipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class CreateRelationPipelet
extends ASesameRecordPipelet {
    public static final String PARAM_SUBJECTATTRIBUTE = "subjectAttribute";
    public static final String PARAM_OBJECTATTRIBUTE = "objectAttribute";
    public static final String PARAM_PREDICATEURI = "predicateUri";

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null && recordIds.length > 0) {
            try {
                ParameterAccessor parameters = this.getParameters(blackboard);
                Id[] idArray = recordIds;
                int n = recordIds.length;
                int n2 = 0;
                while (n2 < n) {
                    Id id = idArray[n2];
                    parameters.setCurrentRecord(id);
                    RepositoryConnection connection = this.getRepositoryConnection(parameters);
                    try {
                        try {
                            String subjectAttribute = parameters.getRequiredParameter(PARAM_SUBJECTATTRIBUTE);
                            Path subjectPath = new Path().add(subjectAttribute);
                            String objectAttribute = parameters.getRequiredParameter(PARAM_OBJECTATTRIBUTE);
                            Path objectPath = new Path().add(objectAttribute);
                            String predicateUriString = parameters.getRequiredParameter(PARAM_PREDICATEURI);
                            URI predicate = this.createUri(connection, predicateUriString);
                            if (blackboard.getLiteralsSize(id, subjectPath) > 0) {
                                List subjects = blackboard.getLiterals(id, subjectPath);
                                List objects = blackboard.getLiterals(id, objectPath);
                                for (Literal subjectLit : subjects) {
                                    URI subject = this.createUri(connection, subjectLit.getStringValue());
                                    for (Literal objectLit : objects) {
                                        Value object = this._valueHelper.createValue(connection, objectLit);
                                        connection.add((Resource)subject, predicate, object, new Resource[0]);
                                    }
                                }
                            }
                            connection.commit();
                        }
                        catch (BlackboardAccessException ex) {
                            throw new ProcessingException("error accessing blackboard", (Throwable)ex);
                        }
                    }
                    finally {
                        connection.close();
                    }
                    ++n2;
                }
            }
            catch (RepositoryException ex) {
                throw new ProcessingException("could not get connection to sesame repository", (Throwable)ex);
            }
        }
        return recordIds;
    }
}

