/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.ontology.pipelets.ASesameRecordPipelet;
import org.eclipse.smila.ontology.records.SesameRecordHelper;
import org.eclipse.smila.ontology.records.SesameRecordReader;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;

public class SesameRecordReaderPipelet
extends ASesameRecordPipelet {
    public static final String PARAM_INCLUDEINFERRED = "includeInferred";
    public static final boolean DEFAULT_INCLUDEINFERRED = false;

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            ParameterAccessor parameters = this.getParameters(blackboard);
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                Id id = idArray[n2];
                try {
                    parameters.setCurrentRecord(id);
                    RepositoryConnection repoConn = this.getRepositoryConnection(parameters);
                    boolean includeInferred = parameters.getBooleanParameter(PARAM_INCLUDEINFERRED, Boolean.valueOf(false));
                    String resourceUri = id.getKey().getKey();
                    Literal uriLiteral = blackboard.getLiteral(id, SesameRecordHelper.PATH_URI);
                    if (uriLiteral != null) {
                        resourceUri = uriLiteral.getStringValue();
                    }
                    URI uri = repoConn.getValueFactory().createURI(resourceUri);
                    SesameRecordReader reader = new SesameRecordReader(repoConn, includeInferred);
                    String recordFilterName = parameters.getParameter("recordFilter", null);
                    if (recordFilterName == null) {
                        reader.readBlackboardRecord(uri, blackboard, id);
                    } else {
                        Record ontoRecord = reader.readRecord(uri);
                        ontoRecord.setId(id);
                        ontoRecord = blackboard.filterRecord(ontoRecord, recordFilterName);
                        blackboard.synchronize(ontoRecord);
                    }
                    repoConn.close();
                }
                catch (Exception ex) {
                    throw new ProcessingException("error reading record from ontology", (Throwable)ex);
                }
                ++n2;
            }
        }
        return recordIds;
    }
}

