/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.ontology.pipelets.ASesameRecordPipelet;
import org.eclipse.smila.ontology.records.SesameRecordWriter;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.openrdf.repository.RepositoryConnection;

public class SesameRecordWriterPipelet
extends ASesameRecordPipelet {
    public static final String PARAM_TYPEURI = "typeUri";

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            ParameterAccessor parameters = this.getParameters(blackboard);
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                Id id = idArray[n2];
                try {
                    parameters.setCurrentRecord(id);
                    RepositoryConnection repoConn = this.getRepositoryConnection(parameters);
                    String recordFilterName = parameters.getParameter("recordFilter", null);
                    String typeUri = parameters.getParameter(PARAM_TYPEURI, null);
                    SesameRecordWriter writer = new SesameRecordWriter(repoConn);
                    if (recordFilterName == null) {
                        writer.writeBlackboardRecord(blackboard, id, typeUri);
                    } else {
                        Record record = blackboard.getRecord(id, recordFilterName);
                        Annotation annotation = blackboard.getAnnotation(id, null, "org.eclipse.smila.ontology");
                        if (annotation != null) {
                            record.getMetadata().setAnnotation("org.eclipse.smila.ontology", annotation);
                        }
                        writer.writeRecord(record, typeUri);
                    }
                    repoConn.close();
                }
                catch (Exception ex) {
                    throw new ProcessingException("error writing record to ontology", (Throwable)ex);
                }
                ++n2;
            }
        }
        return recordIds;
    }
}

