/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.records;

import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.RecordFactory;

public abstract class SesameRecordHelper {
    public static final String SESAME_SOURCE = "SESAME";
    public static final String ATTRIBUTE_URI = "rdf:about";
    public static final Path PATH_URI = new Path();
    public static final String ATTRIBUTE_TYPE = "rdf:type";
    public static final Path PATH_TYPE = new Path();
    public static final String SEMTYPE_RESOURCE = "rdfs:Resource";
    public static final String ANNOTATION_LANG = "xml:lang";
    public static final String ANNOTATION_MODE = "org.eclipse.smila.ontology";
    public static final String ANNOVALUENAME_CLEAR = "clear";
    public static final String ANNOVALUE_REVERSE = "reverse";
    public static final String LOCALE_ALL = "ALL";

    static {
        PATH_URI.add(ATTRIBUTE_URI);
        PATH_TYPE.add(ATTRIBUTE_TYPE);
    }

    private SesameRecordHelper() {
    }

    public static void setLanguage(Literal literal, String language) {
        if (language != null) {
            Annotation annotation = RecordFactory.DEFAULT_INSTANCE.createAnnotation();
            annotation.addAnonValue(language);
            literal.setAnnotation(ANNOTATION_LANG, annotation);
        }
    }

    public static String getLanguage(Literal literal) {
        Annotation annotation;
        if (literal.hasAnnotation(ANNOTATION_LANG) && (annotation = literal.getAnnotation(ANNOTATION_LANG)).hasAnonValues()) {
            return (String)annotation.getAnonValues().iterator().next();
        }
        return null;
    }

    public static Attribute getAttribute(MObject mobject, String attributeName) {
        if (attributeName == null) {
            return null;
        }
        Attribute attribute = mobject.getAttribute(attributeName);
        if (attribute == null) {
            attribute = RecordFactory.DEFAULT_INSTANCE.createAttribute();
            mobject.setAttribute(attributeName, attribute);
        }
        return attribute;
    }

    public static Annotation getModeAnnotation(Annotatable annotatable) {
        Annotation annotation = annotatable.getAnnotation(ANNOTATION_MODE);
        if (annotation == null) {
            annotation = RecordFactory.DEFAULT_INSTANCE.createAnnotation();
            annotatable.addAnnotation(ANNOTATION_MODE, annotation);
        }
        return annotation;
    }

    public static Annotation getModeAnnotation(MObject mobject, String attributeName) {
        Attribute attribute = SesameRecordHelper.getAttribute(mobject, attributeName);
        if (attribute == null) {
            return null;
        }
        return SesameRecordHelper.getModeAnnotation((Annotatable)attribute);
    }

    public static Annotation addClearFlag(MObject mobject) {
        Annotation annotation = SesameRecordHelper.getModeAnnotation((Annotatable)mobject);
        annotation.setNamedValue(ANNOVALUENAME_CLEAR, LOCALE_ALL);
        return annotation;
    }

    public static Annotation addClearFlag(MObject mobject, String attributeName) {
        return SesameRecordHelper.addClearFlag(mobject, attributeName, LOCALE_ALL);
    }

    public static Annotation addClearFlag(MObject mobject, String attributeName, String language) {
        Annotation annotation;
        if (language == null) {
            language = LOCALE_ALL;
        }
        if ((annotation = SesameRecordHelper.getModeAnnotation(mobject, attributeName)) == null) {
            return null;
        }
        annotation.setNamedValue(ANNOVALUENAME_CLEAR, language);
        return annotation;
    }

    public static Annotation addReverseFlag(MObject mobject, String attributeName) {
        Annotation annotation = SesameRecordHelper.getModeAnnotation(mobject, attributeName);
        if (annotation == null) {
            return null;
        }
        annotation.addAnonValue(ANNOVALUE_REVERSE);
        return annotation;
    }
}

