/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.records;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.IdFactory;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.ontology.records.SesameRecordHelper;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class SesameRecordReader {
    private RepositoryConnection _repoConn;
    private boolean _includeInferred;
    private Map<String, String> _namespaces;

    public SesameRecordReader(RepositoryConnection repoConn, boolean includeInferred) {
        this._repoConn = repoConn;
        this._includeInferred = includeInferred;
        this.initNamespaces();
    }

    private void initNamespaces() {
        this._namespaces = new HashMap<String, String>();
        try {
            RepositoryResult repoNamespaces = this._repoConn.getNamespaces();
            while (repoNamespaces.hasNext()) {
                Namespace repoNamespace = (Namespace)repoNamespaces.next();
                String repoPrefix = repoNamespace.getPrefix();
                String currentPrefix = this._namespaces.get(repoNamespace.getName());
                if (currentPrefix != null && repoPrefix.length() >= currentPrefix.length()) continue;
                this._namespaces.put(repoNamespace.getName(), repoPrefix);
            }
        }
        catch (RepositoryException repositoryException) {
        }
    }

    public Id readBlackboardRecord(URI uri, Blackboard blackboard) throws BlackboardAccessException, RepositoryException {
        Id id = this.createId(uri);
        blackboard.create(id);
        this.readBlackboardRecord(uri, blackboard, id);
        return id;
    }

    public void readBlackboardRecord(URI uri, Blackboard blackboard, Id id) throws BlackboardAccessException, RepositoryException {
        org.eclipse.smila.datamodel.record.Literal uriLiteral = blackboard.createLiteral(id);
        uriLiteral.setStringValue(uri.stringValue());
        uriLiteral.setSemanticType("rdfs:Resource");
        blackboard.setLiteral(id, SesameRecordHelper.PATH_URI, uriLiteral);
        RepositoryResult statements = this._repoConn.getStatements((Resource)uri, null, null, this._includeInferred, new Resource[0]);
        if (statements != null) {
            HashMap<String, Path> attributePaths = new HashMap<String, Path>();
            while (statements.hasNext()) {
                Statement statement = (Statement)statements.next();
                String attributeName = this.uriToString(statement.getPredicate());
                org.eclipse.smila.datamodel.record.Literal valueLiteral = blackboard.createLiteral(id);
                this.setLiteralValueFromObject(valueLiteral, statement);
                Path path = (Path)attributePaths.get(attributeName);
                if (path == null) {
                    path = new Path();
                    path.add(attributeName);
                    attributePaths.put(attributeName, path);
                    blackboard.removeLiterals(id, path);
                }
                blackboard.addLiteral(id, path, valueLiteral);
            }
        }
    }

    public Record readRecord(URI uri) throws RepositoryException {
        Id id = this.createId(uri);
        Record record = RecordFactory.DEFAULT_INSTANCE.createRecord();
        record.setId(id);
        this.readRecord(uri, record);
        return record;
    }

    public void readRecord(URI uri, Record record) throws RepositoryException {
        org.eclipse.smila.datamodel.record.Literal uriLiteral = record.getFactory().createLiteral();
        uriLiteral.setStringValue(uri.stringValue());
        uriLiteral.setSemanticType("rdfs:Resource");
        this.setAttributeLiteral(record, "rdf:about", uriLiteral);
        RepositoryResult statements = this._repoConn.getStatements((Resource)uri, null, null, this._includeInferred, new Resource[0]);
        if (statements != null) {
            HashSet<String> attributes = new HashSet<String>();
            while (statements.hasNext()) {
                Statement statement = (Statement)statements.next();
                String attributeName = this.uriToString(statement.getPredicate());
                org.eclipse.smila.datamodel.record.Literal valueLiteral = record.getFactory().createLiteral();
                this.setLiteralValueFromObject(valueLiteral, statement);
                if (attributes.add(attributeName)) {
                    this.setAttributeLiteral(record, attributeName, valueLiteral);
                    continue;
                }
                this.addAttributeLiteral(record, attributeName, valueLiteral);
            }
        }
    }

    private void setLiteralValueFromObject(org.eclipse.smila.datamodel.record.Literal literal, Statement statement) {
        Value value = statement.getObject();
        if (value instanceof Resource) {
            literal.setStringValue(((Resource)value).stringValue());
            literal.setSemanticType("rdfs:Resource");
        } else {
            if (value instanceof Literal) {
                Literal ontoLiteral = (Literal)value;
                SesameRecordHelper.setLanguage(literal, ontoLiteral.getLanguage());
                URI datatype = ontoLiteral.getDatatype();
                if (datatype != null) {
                    if (XMLDatatypeUtil.isIntegerDatatype((URI)datatype)) {
                        literal.setIntValue(Long.valueOf(ontoLiteral.longValue()));
                    } else if (XMLDatatypeUtil.isFloatingPointDatatype((URI)datatype)) {
                        literal.setFpValue(Double.valueOf(ontoLiteral.doubleValue()));
                    } else if (XMLSchema.BOOLEAN.equals((Object)datatype)) {
                        literal.setBoolValue(Boolean.valueOf(ontoLiteral.booleanValue()));
                    } else if (XMLDatatypeUtil.isCalendarDatatype((URI)datatype)) {
                        XMLGregorianCalendar ontoCal = ontoLiteral.calendarValue();
                        if (XMLSchema.DATETIME.equals((Object)datatype)) {
                            GregorianCalendar cal = ontoCal.toGregorianCalendar();
                            literal.setDateTimeValue(cal.getTime());
                        } else if (XMLSchema.TIME.equals((Object)datatype)) {
                            GregorianCalendar cal = ontoCal.toGregorianCalendar();
                            literal.setTimeValue(cal.getTime());
                        } else {
                            Calendar cal = this.getDateOnly(ontoCal);
                            literal.setDateValue(cal.getTime());
                        }
                    }
                }
            }
            if (literal.getValue() == null) {
                literal.setStringValue(value.stringValue());
            }
        }
    }

    private Calendar getDateOnly(XMLGregorianCalendar ontoCal) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(0L);
        if (ontoCal.getYear() != Integer.MIN_VALUE) {
            cal.set(1, ontoCal.getYear());
        }
        if (ontoCal.getMonth() != Integer.MIN_VALUE) {
            cal.set(2, ontoCal.getMonth() - 1);
        }
        if (ontoCal.getDay() != Integer.MIN_VALUE) {
            cal.set(5, ontoCal.getDay());
        }
        return cal;
    }

    private void setAttributeLiteral(Record record, String attributeName, org.eclipse.smila.datamodel.record.Literal literal) {
        Attribute attribute = record.getFactory().createAttribute();
        attribute.setName(attributeName);
        record.getMetadata().setAttribute(attributeName, attribute);
        attribute.addLiteral(literal);
    }

    private void addAttributeLiteral(Record record, String attributeName, org.eclipse.smila.datamodel.record.Literal literal) {
        if (record.getMetadata().hasAttribute(attributeName)) {
            Attribute attribute = record.getMetadata().getAttribute(attributeName);
            attribute.addLiteral(literal);
        } else {
            this.setAttributeLiteral(record, attributeName, literal);
        }
    }

    private Id createId(URI uri) {
        return IdFactory.DEFAULT_INSTANCE.createId("SESAME", uri.stringValue());
    }

    private String uriToString(URI uri) {
        String prefix = this._namespaces.get(uri.getNamespace());
        if (prefix != null) {
            return String.valueOf(prefix) + ":" + uri.getLocalName();
        }
        return uri.stringValue();
    }
}

