/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.records;

import java.util.Calendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.ontology.records.SesameRecordHelper;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class SesameValueHelper {
    public static final SesameValueHelper INSTANCE = new SesameValueHelper();
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    private final Log _log = LogFactory.getLog(this.getClass());

    public Value createValue(RepositoryConnection connection, Literal literal) {
        if ("rdfs:Resource".equals(literal.getSemanticType())) {
            return this.createUri(connection, literal);
        }
        return this.createLiteral(connection, literal);
    }

    public org.openrdf.model.Literal createLiteral(RepositoryConnection connection, Literal literal) {
        org.openrdf.model.Literal value;
        switch (literal.getDataType()) {
            case INT: {
                value = connection.getValueFactory().createLiteral(literal.getIntValue().longValue());
                break;
            }
            case FP: {
                value = connection.getValueFactory().createLiteral(literal.getFpValue().doubleValue());
                break;
            }
            case BOOL: {
                value = connection.getValueFactory().createLiteral(literal.getBoolValue().booleanValue());
                break;
            }
            case DATE: {
                value = this.createDateLiteral(connection, literal);
                break;
            }
            case DATETIME: {
                value = this.createDateTimeLiteral(connection, literal);
                break;
            }
            case TIME: {
                value = this.createTimeLiteral(connection, literal);
                break;
            }
            default: {
                String locale = SesameRecordHelper.getLanguage(literal);
                value = locale != null ? connection.getValueFactory().createLiteral(literal.getStringValue(), locale) : connection.getValueFactory().createLiteral(literal.getStringValue());
            }
        }
        return value;
    }

    private org.openrdf.model.Literal createDateLiteral(RepositoryConnection connection, Literal literal) {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            Calendar cal = Calendar.getInstance();
            cal.setTime(literal.getDateValue());
            XMLGregorianCalendar time = factory.newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), 0);
            return connection.getValueFactory().createLiteral(time);
        }
        catch (Exception ex) {
            this._log.warn((Object)("cuold not create a time literal from value '" + literal + "', just adding a string literal"), (Throwable)ex);
            return connection.getValueFactory().createLiteral(literal.getStringValue());
        }
    }

    private org.openrdf.model.Literal createTimeLiteral(RepositoryConnection connection, Literal literal) {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            Calendar cal = Calendar.getInstance();
            cal.setTime(literal.getTimeValue());
            int zoneOffsetMinutes = cal.get(15) / 60000;
            XMLGregorianCalendar time = factory.newXMLGregorianCalendarTime(cal.get(11), cal.get(12), cal.get(13), cal.get(14), zoneOffsetMinutes);
            return connection.getValueFactory().createLiteral(time);
        }
        catch (Exception ex) {
            this._log.warn((Object)("cuold not create a time literal from value '" + literal + "', just adding a string literal"), (Throwable)ex);
            return connection.getValueFactory().createLiteral(literal.getStringValue());
        }
    }

    private org.openrdf.model.Literal createDateTimeLiteral(RepositoryConnection connection, Literal literal) {
        try {
            DatatypeFactory factory = DatatypeFactory.newInstance();
            Calendar cal = Calendar.getInstance();
            cal.setTime(literal.getDateTimeValue());
            int zoneOffsetMinutes = cal.get(15) / 60000;
            XMLGregorianCalendar time = factory.newXMLGregorianCalendar(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), zoneOffsetMinutes);
            return connection.getValueFactory().createLiteral(time);
        }
        catch (Exception ex) {
            this._log.warn((Object)("cuold not create a time literal from value '" + literal + "', just adding a string literal"), (Throwable)ex);
            return connection.getValueFactory().createLiteral(literal.getStringValue());
        }
    }

    public URI createUri(RepositoryConnection connection, Literal uri) {
        return this.createUri(connection, uri.getStringValue());
    }

    public URI createUri(RepositoryConnection connection, String uriString) {
        int prefixIndex = uriString.indexOf(58);
        if (prefixIndex >= 0 && prefixIndex < uriString.length() - 1) {
            String prefix = uriString.substring(0, prefixIndex);
            try {
                String fullNamespace = connection.getNamespace(prefix);
                if (fullNamespace != null) {
                    String localName = uriString.substring(prefixIndex + 1);
                    return connection.getValueFactory().createURI(fullNamespace, localName);
                }
            }
            catch (RepositoryException repositoryException) {
            }
        }
        return connection.getValueFactory().createURI(uriString);
    }
}

