/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.rtrep.v2.OExtensionActivity;
import org.apache.ode.bpel.rtrep.v2.OProcess;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.ProcessingService;
import org.eclipse.smila.processing.ProcessorMessage;
import org.eclipse.smila.processing.SearchMessage;
import org.eclipse.smila.processing.SearchProcessingService;
import org.eclipse.smila.processing.bpel.ExtensionAdapter;
import org.eclipse.smila.processing.bpel.ExtensionManager;
import org.eclipse.smila.processing.bpel.ODEWorkflowProcessor;
import org.eclipse.smila.processing.bpel.ProcessingServiceInvoker;
import org.eclipse.smila.processing.bpel.ServicePerformanceCounter;
import org.w3c.dom.Element;

public final class ProcessingServiceManager
extends ExtensionManager {
    private static final ProcessingServiceManager INSTANCE = new ProcessingServiceManager();
    private final Log _log = LogFactory.getLog(this.getClass());

    private ProcessingServiceManager() {
    }

    public static ProcessingServiceManager getInstance() {
        return INSTANCE;
    }

    @Override
    public String getExtensionName() {
        return "invokeService";
    }

    @Override
    public ProcessingServiceInvoker doRegisterActivity(OProcess pipelineProcess, OExtensionActivity activity, Element content, String key) {
        ProcessingServiceInvoker invoker = new ProcessingServiceInvoker();
        invoker.setServiceName(this.getAttributeOfElement(content, "service", "name"));
        if (invoker.getServiceName() == null) {
            throw new CompilationException(this.createErrorCompilationMessage(key, "Missing definition of service name"));
        }
        String location = activity.name.substring(activity.name.lastIndexOf("line-"));
        invoker.setCounter(new ServicePerformanceCounter(pipelineProcess.getName(), invoker.getServiceName(), location));
        return invoker;
    }

    @Override
    public void checkAvailability(ExtensionAdapter adapter, ODEWorkflowProcessor processor) throws ProcessingException {
        SearchProcessingService searchService;
        ProcessingService service = this.getProcessingService(adapter, processor);
        if (service == null && (searchService = this.getSearchProcessingService(adapter, processor)) == null) {
            throw new ProcessingException(String.valueOf(adapter.getPrintName()) + " for activity " + adapter.getKey() + " is not yet registered.");
        }
    }

    @Override
    public ProcessorMessage doInvoke(ExtensionAdapter adapter, ODEWorkflowProcessor processor, Blackboard blackboard, ProcessorMessage request) throws ProcessingException {
        int incomingIds = 0;
        int outgoingIds = 0;
        try {
            SearchProcessingService searchService;
            if (request instanceof SearchMessage && (searchService = this.getSearchProcessingService(adapter, processor)) != null) {
                incomingIds = this.getRecordCount(((SearchMessage)request).getRecords()) + 1;
                SearchMessage result = searchService.process(blackboard, (SearchMessage)request);
                outgoingIds = this.getRecordCount(result.getRecords()) + 1;
                SearchMessage searchMessage = result;
                return searchMessage;
            }
            ProcessingService procService = this.getProcessingService(adapter, processor);
            if (procService != null) {
                if (request instanceof SearchMessage && !((SearchMessage)request).hasRecords()) {
                    SearchMessage searchRequest = (SearchMessage)request;
                    if (searchRequest.hasQuery()) {
                        Id[] query = new Id[]{searchRequest.getQuery()};
                        incomingIds = 1;
                        Id[] result = procService.process(blackboard, query);
                        outgoingIds = this.getRecordCount(result);
                        if (result.length > 0) {
                            searchRequest.setQuery(query[0]);
                            if (result.length > 1) {
                                this._log.warn((Object)(String.valueOf(adapter.getPrintName()) + " has splitted a query object. Extra objects are ignored."));
                            }
                        }
                    }
                } else {
                    incomingIds = this.getRecordCount(request.getRecords());
                    Id[] result = procService.process(blackboard, request.getRecords());
                    outgoingIds = this.getRecordCount(result);
                    request.setRecords(result);
                }
                ProcessorMessage processorMessage = request;
                return processorMessage;
            }
            throw new ProcessingException("Could not invoke " + adapter.getPrintName() + "Either the service does not exist or you tried to invoke a search service with a simple variable.");
        }
        finally {
            if (adapter.getCounter() != null) {
                adapter.getCounter().countIds(incomingIds, outgoingIds);
            }
        }
    }

    private ProcessingService getProcessingService(ExtensionAdapter adapter, ODEWorkflowProcessor processor) {
        String serviceName = ((ProcessingServiceInvoker)adapter).getServiceName();
        return processor.getProcessingService(serviceName);
    }

    private SearchProcessingService getSearchProcessingService(ExtensionAdapter adapter, ODEWorkflowProcessor processor) {
        String serviceName = ((ProcessingServiceInvoker)adapter).getServiceName();
        return processor.getSearchProcessingService(serviceName);
    }
}

