/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel;

import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.compiler.v2.BpelCompiler20;
import org.apache.ode.bpel.extension.ExtensibleElement;
import org.apache.ode.bpel.extension.ExtensionOperation;
import org.apache.ode.bpel.extension.ExtensionValidator;
import org.apache.ode.bpel.rtrep.common.extension.AbstractExtensionBundle;
import org.apache.ode.bpel.rtrep.common.extension.ExtensionContext;
import org.apache.ode.bpel.rtrep.v2.OExtensionActivity;
import org.eclipse.smila.processing.bpel.PipeletManager;
import org.eclipse.smila.processing.bpel.ProcessingServiceManager;
import org.w3c.dom.Element;

public class SMILAExtensionBundle
extends AbstractExtensionBundle {
    public static final String TAG_INVOKE_PIPELET = "invokePipelet";
    public static final String TAG_INVOKE_SERVICE = "invokeService";

    public String getNamespaceURI() {
        return "http://www.eclipse.org/smila/processor";
    }

    public void registerExtensionActivities() {
        this.registerExtensionOperation(TAG_INVOKE_PIPELET, InvokePipeletActivity.class);
        this.registerExtensionOperation(TAG_INVOKE_SERVICE, InvokeServiceActivity.class);
    }

    public static class InvokePipeletActivity
    implements ExtensionOperation,
    ExtensionValidator {
        public void run(ExtensionContext context, Element element) throws FaultException {
            PipeletManager.getInstance().invokeActivity(context, element);
        }

        public void run(Object contexto, Element element) throws FaultException {
            ExtensionContext context = (ExtensionContext)contexto;
            this.run(context, element);
        }

        public void validate(Object compilerContext, ExtensibleElement element) {
            BpelCompiler20 compiler = (BpelCompiler20)compilerContext;
            OExtensionActivity activity = (OExtensionActivity)compiler.getCurrent();
            PipeletManager.getInstance().registerActivity(activity, element);
        }
    }

    public static class InvokeServiceActivity
    implements ExtensionOperation,
    ExtensionValidator {
        public void run(ExtensionContext context, Element element) throws FaultException {
            ProcessingServiceManager.getInstance().invokeActivity(context, element);
        }

        public void run(Object contexto, Element element) throws FaultException {
            ExtensionContext context = (ExtensionContext)contexto;
            this.run(context, element);
        }

        public void validate(Object compilerContext, ExtensibleElement element) {
            BpelCompiler20 compiler = (BpelCompiler20)compilerContext;
            OExtensionActivity activity = (OExtensionActivity)compiler.getCurrent();
            ProcessingServiceManager.getInstance().registerActivity(activity, element);
        }
    }
}

