/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.agent.mock;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.AbstractAgent;
import org.eclipse.smila.connectivity.framework.AgentException;
import org.eclipse.smila.connectivity.framework.agent.mock.messages.Attribute;
import org.eclipse.smila.connectivity.framework.agent.mock.messages.Process;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.util.AgentThreadState;
import org.eclipse.smila.connectivity.framework.util.ConnectivityHashFactory;
import org.eclipse.smila.connectivity.framework.util.ConnectivityIdFactory;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.InvalidTypeException;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;

public class MockAgent
extends AbstractAgent {
    private static final long MILLI_SECOND_MULTIPLIER = 1000L;
    private final RecordFactory _factory = RecordFactory.DEFAULT_INSTANCE;
    private final Log _log = LogFactory.getLog(MockAgent.class);
    private long _sleepTime;
    private Attribute[] _attributes;

    public MockAgent() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Creating MockAgent instance");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (true) {
                    if (this.isStopThread()) {
                        return;
                    }
                    try {
                        StringBuffer hash = new StringBuffer();
                        Record record = this.createRecord(hash);
                        if (this._log.isTraceEnabled()) {
                            this._log.trace((Object)("created record with Id " + record.getId()));
                        }
                        this.getControllerCallback().add(this.getSessionId(), this.getConfig().getDeltaIndexing(), record, hash.toString());
                        Thread.sleep(this._sleepTime);
                    }
                    catch (InterruptedException e) {
                        if (!this._log.isTraceEnabled()) continue;
                        this._log.trace((Object)"agent thread was interrupted ", (Throwable)e);
                    }
                }
            }
            catch (Throwable t) {
                this.getAgentState().setLastError(t);
                this.getAgentState().setState(AgentThreadState.Aborted);
                throw new RuntimeException(t);
            }
        }
        finally {
            try {
                this.stopThread();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void initialize() throws AgentException {
        this._sleepTime = ((Process)this.getConfig().getProcess()).getSleepTime().longValue() * 1000L;
        DataSourceConnectionConfig.Attributes attributes = this.getConfig().getAttributes();
        List attrs = attributes.getAttribute();
        this._attributes = attrs.toArray(new Attribute[attrs.size()]);
    }

    private Record createRecord(StringBuffer hash) throws AgentException, InvalidTypeException {
        MockAgentData data = new MockAgentData();
        ArrayList<org.eclipse.smila.datamodel.record.Attribute> idAttributes = new ArrayList<org.eclipse.smila.datamodel.record.Attribute>();
        ArrayList<org.eclipse.smila.datamodel.record.Attribute> hashAttributes = new ArrayList<org.eclipse.smila.datamodel.record.Attribute>();
        HashMap<String, byte[]> hashAttachments = new HashMap<String, byte[]>();
        this.readIdAndHashAttributesAndAttachments(data, idAttributes, hashAttributes, hashAttachments);
        Id id = ConnectivityIdFactory.getInstance().createId(this.getConfig().getDataSourceID(), idAttributes.toArray(new org.eclipse.smila.datamodel.record.Attribute[idAttributes.size()]));
        hash.append(ConnectivityHashFactory.getInstance().createHash(hashAttributes.toArray(new org.eclipse.smila.datamodel.record.Attribute[hashAttributes.size()]), hashAttachments));
        MObject metadata = this._factory.createMetadataObject();
        Record record = this._factory.createRecord();
        record.setId(id);
        record.setMetadata(metadata);
        this.fillRecord(data, record);
        return record;
    }

    private void readIdAndHashAttributesAndAttachments(MockAgentData data, List<org.eclipse.smila.datamodel.record.Attribute> idAttributes, List<org.eclipse.smila.datamodel.record.Attribute> hashAttributes, Map<String, byte[]> hashAttachments) throws AgentException, InvalidTypeException {
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attributeDef = attributeArray[n2];
            if (attributeDef.isKeyAttribute() || attributeDef.isHashAttribute()) {
                Object value;
                if (attributeDef.isAttachment()) {
                    value = this.readAttachment(data, attributeDef);
                    hashAttachments.put(attributeDef.getName(), (byte[])value);
                } else {
                    value = this.readAttribute(data, attributeDef);
                    if (value != null) {
                        org.eclipse.smila.datamodel.record.Attribute attribute = this._factory.createAttribute();
                        attribute.setName(attributeDef.getName());
                        Literal literal = this._factory.createLiteral();
                        literal.setValue(value);
                        attribute.addLiteral(literal);
                        if (attributeDef.isKeyAttribute()) {
                            idAttributes.add(attribute);
                        }
                        if (attributeDef.isHashAttribute()) {
                            hashAttributes.add(attribute);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void fillRecord(MockAgentData data, Record record) throws AgentException, InvalidTypeException {
        Attribute[] attributeArray = this._attributes;
        int n = this._attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Object value;
            Attribute attributeDef = attributeArray[n2];
            if (attributeDef.isAttachment()) {
                value = this.readAttachment(data, attributeDef);
                record.setAttachment(attributeDef.getName(), value);
            } else {
                value = this.readAttribute(data, attributeDef);
                if (value != null) {
                    org.eclipse.smila.datamodel.record.Attribute attribute = this._factory.createAttribute();
                    attribute.setName(attributeDef.getName());
                    Literal literal = this._factory.createLiteral();
                    literal.setValue(value);
                    attribute.addLiteral(literal);
                    record.getMetadata().setAttribute(attributeDef.getName(), attribute);
                }
            }
            ++n2;
        }
    }

    private Serializable readAttribute(MockAgentData data, Attribute attribute) throws AgentException {
        switch (attribute.getMockAttributes()) {
            case IDENTIFIER: {
                return data.getIdentifier();
            }
            case LAST_MODIFIED_DATE: {
                return data.getLastModified();
            }
            case MIME_TYPE: {
                return data.getMimeType();
            }
            case CONTENT: {
                return data.getContent();
            }
        }
        throw new RuntimeException("Unknown mock attributes type " + (Object)((Object)attribute.getMockAttributes()));
    }

    private byte[] readAttachment(MockAgentData data, Attribute attribute) throws AgentException {
        Serializable value = this.readAttribute(data, attribute);
        if (value != null) {
            if (value instanceof String) {
                try {
                    return ((String)((Object)value)).getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new AgentException((Throwable)e);
                }
            }
            if (value instanceof byte[]) {
                return (byte[])value;
            }
        }
        return null;
    }

    private class MockAgentData {
        private Date _lastModified;
        private String _identifier;
        private String _mimeType;
        private String _content;

        MockAgentData() {
            long currentTime = System.currentTimeMillis();
            this._lastModified = new Date(currentTime);
            this._identifier = Long.toString(currentTime);
            this._mimeType = "text/plain";
            this._content = "This is some text content generated by MockAgent at " + this._lastModified;
        }

        public Date getLastModified() {
            return this._lastModified;
        }

        public String getIdentifier() {
            return this._identifier;
        }

        public String getMimeType() {
            return this._mimeType;
        }

        public String getContent() {
            return this._content;
        }
    }
}

