/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public class Main {
    public static final String PROP_MAINCLASS = Main.class.getName() + ".mainClass";

    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("LAUNCHER FAILURE: A configuration file must be supplied as an argument.");
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            throw new IllegalArgumentException("BOOTSTRAP FAILURE: No such file " + file);
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        String string = properties.getProperty(PROP_MAINCLASS);
        if (string == null) {
            throw new IllegalArgumentException("BOOTSTRAP FAILURE: The configuration file" + file + " does not set the " + PROP_MAINCLASS + " property.");
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        Class<?> clazz = Class.forName(string);
        Method method = clazz.getMethod("main", String[].class);
        try {
            method.invoke(clazz, new Object[]{stringArray2});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }
}

