/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.stax.IdReader;
import org.eclipse.smila.datamodel.id.stax.IdWriter;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.dom.RecordParser;
import org.eclipse.smila.datamodel.record.stax.RecordReader;
import org.eclipse.smila.datamodel.record.stax.RecordWriter;
import org.eclipse.smila.datamodel.tools.DatamodelDeserializationException;
import org.w3c.dom.Document;

public final class DatamodelSerializationUtils {
    private static RecordParser s_recordParser;
    private static XMLOutputFactory s_staxWriterFactory;
    private static XMLInputFactory s_staxReaderFactory;
    private static RecordWriter s_recordWriter;
    private static RecordReader s_recordReader;
    private static IdWriter s_idWriter;
    private static IdReader s_idReader;

    private DatamodelSerializationUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String serialize2string(Id id) {
        if (id == null) {
            return null;
        }
        try {
            String string;
            ByteArrayOutputStream out;
            block14: {
                out = new ByteArrayOutputStream();
                XMLStreamWriter writer = null;
                try {
                    writer = DatamodelSerializationUtils.getStaxWriterFactory().createXMLStreamWriter(out, "utf-8");
                    writer.writeStartDocument("utf-8", "1.1");
                    DatamodelSerializationUtils.getIdWriter().writeId(writer, id);
                    writer.writeEndDocument();
                    string = out.toString("utf-8");
                    if (writer == null) break block14;
                }
                catch (Exception e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (XMLStreamException xMLStreamException) {}
                        }
                        if (out != null) {
                            IOUtils.closeQuietly((OutputStream)out);
                        }
                        throw throwable;
                    }
                }
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (out != null) {
                IOUtils.closeQuietly((OutputStream)out);
            }
            return string;
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String serialize2string(Record record) {
        if (record == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = DatamodelSerializationUtils.serialize2stream(record);
            return out.toString("utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] serialize2byteArray(Record record) {
        if (record == null) {
            return null;
        }
        try {
            RecordByteWrapper wrapper = new RecordByteWrapper(DatamodelSerializationUtils.serialize2stream(record).toByteArray());
            Iterator attachmentNames = record.getAttachmentNames();
            while (attachmentNames.hasNext()) {
                String attachmentName = (String)attachmentNames.next();
                wrapper.getAttachments().put(attachmentName, record.getAttachment(attachmentName));
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                try {
                    out = new ObjectOutputStream(bos);
                    out.writeObject(wrapper);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly((OutputStream)bos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((OutputStream)bos);
            return bos.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteArrayOutputStream serialize2stream(Record record) {
        if (record == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLStreamWriter writer = null;
        try {
            try {
                writer = DatamodelSerializationUtils.getStaxWriterFactory().createXMLStreamWriter(out, "utf-8");
                writer.writeStartDocument("utf-8", "1.1");
                DatamodelSerializationUtils.getRecordWriter().writeRecord(writer, record);
                writer.writeEndDocument();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (out != null) {
                IOUtils.closeQuietly((OutputStream)out);
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (XMLStreamException xMLStreamException) {}
        }
        if (out != null) {
            IOUtils.closeQuietly((OutputStream)out);
        }
        return out;
    }

    public static Record deserialize(byte[] byteArray) throws DatamodelDeserializationException {
        Record record;
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        ObjectInputStream wrapperInputStream = null;
        ByteArrayInputStream recordInputStream = new ByteArrayInputStream(byteArray);
        try {
            RecordByteWrapper wrapper = null;
            try {
                wrapperInputStream = new ObjectInputStream(bis);
                wrapper = (RecordByteWrapper)wrapperInputStream.readObject();
                recordInputStream = wrapper.getRecordAsStream();
            }
            catch (Exception e) {
                throw new DatamodelDeserializationException(e);
            }
            XMLStreamReader reader = DatamodelSerializationUtils.getStaxReaderFactory().createXMLStreamReader(recordInputStream);
            reader.nextTag();
            Record record2 = DatamodelSerializationUtils.getRecordReader().readRecord(reader);
            if (wrapper.getAttachments() != null && !wrapper.getAttachments().isEmpty()) {
                for (String attachmentName : wrapper.getAttachments().keySet()) {
                    record2.setAttachment(attachmentName, wrapper.getAttachments().get(attachmentName));
                }
            }
            record = record2;
        }
        catch (XMLStreamException e) {
            try {
                throw new DatamodelDeserializationException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)bis);
                IOUtils.closeQuietly(wrapperInputStream);
                IOUtils.closeQuietly((InputStream)recordInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)wrapperInputStream);
        IOUtils.closeQuietly((InputStream)recordInputStream);
        return record;
    }

    public static Record deserialize(String xmlString) throws DatamodelDeserializationException {
        try {
            return DatamodelSerializationUtils.deserialize(xmlString.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new DatamodelDeserializationException(e);
        }
    }

    public static Id deserializeId(String xmlString) throws DatamodelDeserializationException {
        try {
            return DatamodelSerializationUtils.deserializeId(xmlString.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new DatamodelDeserializationException(e);
        }
    }

    public static Id deserializeId(byte[] byteArray) throws DatamodelDeserializationException {
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        ByteArrayInputStream idInputStream = new ByteArrayInputStream(byteArray);
        try {
            Id id;
            XMLStreamReader reader = DatamodelSerializationUtils.getStaxReaderFactory().createXMLStreamReader(idInputStream);
            reader.nextTag();
            Id id2 = id = DatamodelSerializationUtils.getIdReader().readId(reader);
            return id2;
        }
        catch (XMLStreamException e) {
            throw new DatamodelDeserializationException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
            IOUtils.closeQuietly((InputStream)idInputStream);
        }
    }

    public static Record deserialize(Document document) throws DatamodelDeserializationException {
        try {
            if (document == null || document.getDocumentElement() == null) {
                throw new DatamodelDeserializationException("No XML document found");
            }
            return DatamodelSerializationUtils.getRecordParser().parseRecordFrom(document.getDocumentElement());
        }
        catch (Exception e) {
            throw new DatamodelDeserializationException(e);
        }
    }

    public static RecordParser getRecordParser() {
        if (s_recordParser == null) {
            s_recordParser = new RecordParser();
        }
        return s_recordParser;
    }

    public static XMLOutputFactory getStaxWriterFactory() {
        if (s_staxWriterFactory == null) {
            s_staxWriterFactory = XMLOutputFactory.newInstance();
        }
        return s_staxWriterFactory;
    }

    public static XMLInputFactory getStaxReaderFactory() {
        if (s_staxReaderFactory == null) {
            s_staxReaderFactory = XMLInputFactory.newInstance();
        }
        return s_staxReaderFactory;
    }

    public static RecordWriter getRecordWriter() {
        if (s_recordWriter == null) {
            s_recordWriter = new RecordWriter(true);
        }
        return s_recordWriter;
    }

    public static RecordReader getRecordReader() {
        if (s_recordReader == null) {
            s_recordReader = new RecordReader();
        }
        return s_recordReader;
    }

    public static IdWriter getIdWriter() {
        if (s_idWriter == null) {
            s_idWriter = new IdWriter(true);
        }
        return s_idWriter;
    }

    public static IdReader getIdReader() {
        if (s_idReader == null) {
            s_idReader = new IdReader();
        }
        return s_idReader;
    }

    private static class RecordByteWrapper
    implements Serializable {
        private static final long serialVersionUID = -6375342925771895197L;
        private final byte[] _recordBytes;
        private final Map<String, byte[]> _attachments = new HashMap<String, byte[]>();

        public RecordByteWrapper(byte[] recordBytes) {
            this._recordBytes = recordBytes;
        }

        public ByteArrayInputStream getRecordAsStream() {
            return new ByteArrayInputStream(this._recordBytes);
        }

        public Map<String, byte[]> getAttachments() {
            return this._attachments;
        }
    }
}

