/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.tools.record.filter;

import java.io.InputStream;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.datamodel.tools.record.filter.RecordFilterLoadSaveException;
import org.eclipse.smila.datamodel.tools.record.filter.RecordFilterNotFoundException;
import org.eclipse.smila.datamodel.tools.record.filter.RecordFilterUtils;
import org.eclipse.smila.datamodel.tools.record.filter.messages.Filter;
import org.eclipse.smila.datamodel.tools.record.filter.messages.RecordFilters;

public class RecordFilterHelper {
    private final RecordFilters _filters;

    public RecordFilterHelper(InputStream inputStream) throws RecordFilterLoadSaveException {
        this._filters = RecordFilterUtils.unmarshall(inputStream);
    }

    public RecordFilterHelper(RecordFilters filters) {
        if (filters == null) {
            throw new IllegalArgumentException("filters parameter cannot be null!");
        }
        this._filters = filters;
    }

    public Record filter(Record record, String filterName) throws RecordFilterNotFoundException {
        Filter filter = RecordFilterUtils.findFilter(this._filters, filterName);
        return RecordFilterUtils.filter(filter, record);
    }

    public MObject filter(MObject mObject, String filterName, RecordFactory factory) throws RecordFilterNotFoundException {
        Filter filter = RecordFilterUtils.findFilter(this._filters, filterName);
        return RecordFilterUtils.filter(filter, mObject, factory);
    }
}

