/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.MethodAliasInfo;
import org.apache.derby.catalog.types.OldRoutineType;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public class RoutineAliasInfo
extends MethodAliasInfo {
    private static final String[] SQL_CONTROL = new String[]{"MODIFIES SQL DATA", "READS SQL DATA", "CONTAINS SQL", "NO SQL"};
    public static final short MODIFIES_SQL_DATA = 0;
    public static final short READS_SQL_DATA = 1;
    public static final short CONTAINS_SQL = 2;
    public static final short NO_SQL = 3;
    public static final short PS_JAVA = 0;
    public static final short PS_DERBY_JDBC_RESULT_SET = 1;
    private static final short SQL_ALLOWED_MASK = 15;
    private static final short DETERMINISTIC_MASK = 16;
    private int parameterCount;
    private TypeDescriptor[] parameterTypes;
    private String[] parameterNames;
    private int[] parameterModes;
    private int dynamicResultSets;
    private TypeDescriptor returnType;
    private short parameterStyle;
    private short sqlOptions;
    private String specificName;
    private boolean calledOnNullInput;
    private transient char aliasType;

    public RoutineAliasInfo() {
    }

    public RoutineAliasInfo(String string, int n, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int[] nArray, int n2, short s, short s2, boolean bl) {
        this(string, n, stringArray, typeDescriptorArray, nArray, n2, s, s2, bl, true, null);
    }

    public RoutineAliasInfo(String string, int n, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int[] nArray, int n2, short s, short s2, boolean bl, boolean bl2, TypeDescriptor typeDescriptor) {
        super(string);
        this.parameterCount = n;
        this.parameterNames = stringArray;
        this.parameterTypes = typeDescriptorArray;
        this.parameterModes = nArray;
        this.dynamicResultSets = n2;
        this.parameterStyle = s;
        this.sqlOptions = (short)(s2 & 0xF);
        if (bl) {
            this.sqlOptions = (short)(this.sqlOptions | 0x10);
        }
        this.calledOnNullInput = bl2;
        this.returnType = typeDescriptor;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public TypeDescriptor[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int[] getParameterModes() {
        return this.parameterModes;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public int getMaxDynamicResultSets() {
        return this.dynamicResultSets;
    }

    public short getParameterStyle() {
        return this.parameterStyle;
    }

    public short getSQLAllowed() {
        return (short)(this.sqlOptions & 0xF);
    }

    public boolean isDeterministic() {
        return (this.sqlOptions & 0x10) != 0;
    }

    public boolean calledOnNullInput() {
        return this.calledOnNullInput;
    }

    public TypeDescriptor getReturnType() {
        return this.returnType;
    }

    public boolean isTableFunction() {
        if (this.returnType == null) {
            return false;
        }
        return this.returnType.isRowMultiSet();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.specificName = (String)objectInput.readObject();
        this.dynamicResultSets = objectInput.readInt();
        this.parameterCount = objectInput.readInt();
        this.parameterStyle = objectInput.readShort();
        this.sqlOptions = objectInput.readShort();
        this.returnType = RoutineAliasInfo.getStoredType(objectInput.readObject());
        this.calledOnNullInput = objectInput.readBoolean();
        objectInput.readInt();
        if (this.parameterCount != 0) {
            this.parameterNames = new String[this.parameterCount];
            this.parameterTypes = new TypeDescriptor[this.parameterCount];
            ArrayUtil.readArrayItems(objectInput, this.parameterNames);
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                this.parameterTypes[i] = RoutineAliasInfo.getStoredType(objectInput.readObject());
            }
            this.parameterModes = ArrayUtil.readIntArray(objectInput);
        } else {
            this.parameterNames = null;
            this.parameterTypes = null;
            this.parameterModes = null;
        }
    }

    private static TypeDescriptor getStoredType(Object object) {
        if (object instanceof OldRoutineType) {
            return ((OldRoutineType)object).getCatalogType();
        }
        return (TypeDescriptor)object;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.specificName);
        objectOutput.writeInt(this.dynamicResultSets);
        objectOutput.writeInt(this.parameterCount);
        objectOutput.writeShort(this.parameterStyle);
        objectOutput.writeShort(this.sqlOptions);
        objectOutput.writeObject(this.returnType);
        objectOutput.writeBoolean(this.calledOnNullInput);
        objectOutput.writeInt(0);
        if (this.parameterCount != 0) {
            ArrayUtil.writeArrayItems(objectOutput, this.parameterNames);
            ArrayUtil.writeArrayItems(objectOutput, this.parameterTypes);
            ArrayUtil.writeIntArray(objectOutput, this.parameterModes);
        }
    }

    public int getTypeFormatId() {
        return 451;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getMethodName());
        stringBuffer.append('(');
        for (int i = 0; i < this.parameterCount; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            if (this.returnType == null) {
                stringBuffer.append(RoutineAliasInfo.parameterMode(this.parameterModes[i]));
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.parameterNames[i]);
            stringBuffer.append(' ');
            stringBuffer.append(this.parameterTypes[i].getSQLstring());
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(" RETURNS " + this.returnType.getSQLstring());
        }
        stringBuffer.append(" LANGUAGE JAVA PARAMETER STYLE ");
        switch (this.parameterStyle) {
            case 0: {
                stringBuffer.append("JAVA ");
                break;
            }
            case 1: {
                stringBuffer.append("DERBY_JDBC_RESULT_SET ");
            }
        }
        if (this.isDeterministic()) {
            stringBuffer.append(" DETERMINISTIC ");
        }
        stringBuffer.append(SQL_CONTROL[this.getSQLAllowed()]);
        if (this.returnType == null && this.dynamicResultSets != 0) {
            stringBuffer.append(" DYNAMIC RESULT SETS ");
            stringBuffer.append(this.dynamicResultSets);
        }
        if (this.returnType != null) {
            stringBuffer.append(this.calledOnNullInput ? " CALLED " : " RETURNS NULL ");
            stringBuffer.append("ON NULL INPUT");
        }
        return stringBuffer.toString();
    }

    public static String parameterMode(int n) {
        switch (n) {
            case 1: {
                return "IN";
            }
            case 4: {
                return "OUT";
            }
            case 2: {
                return "INOUT";
            }
        }
        return "UNKNOWN";
    }

    public void setCollationTypeForAllStringTypes(int n) {
        if (this.parameterCount != 0) {
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                this.parameterTypes[i] = DataTypeDescriptor.getCatalogType(this.parameterTypes[i], n);
            }
        }
        if (this.returnType != null) {
            this.returnType = DataTypeDescriptor.getCatalogType(this.returnType, n);
        }
    }
}

