/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.deltaindexing.jpa.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.IdHandlingException;

public class DeltaIndexingDao
implements Serializable {
    public static final String NAMED_QUERY_FIND_OBSOLETE_IDS_BY_SOURCE = "DeltaIndexingDao.findObsoleteIdsBySource";
    public static final String NAMED_QUERY_FIND_SUB_COMPOUNDS = "DeltaIndexingDao.findSubCompounds";
    public static final String NAMED_QUERY_DELETE_BY_SOURCE = "DeltaIndexingDao.deleteBySource";
    public static final String NAMED_QUERY_DELETE_ALL = "DeltaIndexingDao.deleteAll";
    public static final String NAMED_QUERY_RESET_FLAGS = "DeltaIndexingDao.resetFlags";
    public static final String NAMED_QUERY_COUNT_ENTRIES = "DeltaIndexingDao.countEntries";
    public static final String NAMED_QUERY_COUNT_ENTRIES_BY_SOURCE = "DeltaIndexingDao.countEntriesBySource";
    public static final String NAMED_QUERY_PARAM_SOURCE = "source";
    public static final String NAMED_QUERY_PARAM_PARENT_ID_HASH = "parentIdHash";
    private static final long serialVersionUID = 6500268394234442139L;
    private String _idHash;
    private String _hash;
    private String _dataSourceId;
    private boolean _isCompound;
    private String _parentIdHash;
    private boolean _visited;
    private boolean _modified;
    private byte[] _serializedId;

    protected DeltaIndexingDao() {
    }

    public DeltaIndexingDao(Id id, String hash, boolean isCompound, boolean visited) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("parameter id is null");
        }
        if (hash == null) {
            throw new IllegalArgumentException("parameter hash is null");
        }
        this._idHash = id.getIdHash();
        this._hash = hash;
        this._dataSourceId = id.getSource();
        this._isCompound = isCompound;
        this._visited = visited;
        try {
            Id parentId = id.createCompoundId();
            if (parentId != null) {
                this._parentIdHash = parentId.getIdHash();
            }
        }
        catch (IdHandlingException idHandlingException) {}
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
        objectStream.writeObject(id);
        objectStream.close();
        this._serializedId = byteStream.toByteArray();
    }

    public Id toId() throws IOException, ClassNotFoundException {
        ObjectInputStream objectStream = new ObjectInputStream(new ByteArrayInputStream(this._serializedId));
        return (Id)objectStream.readObject();
    }

    public String getIdHash() {
        return this._idHash;
    }

    public String getHash() {
        return this._hash;
    }

    public String getDataSourceId() {
        return this._dataSourceId;
    }

    public boolean isCompound() {
        return this._isCompound;
    }

    public String getParentIdHash() {
        return this._parentIdHash;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public boolean isModified() {
        return this._modified;
    }

    public void visit() {
        this._visited = true;
    }

    public void modifyAndVisit() {
        this._visited = true;
        this._modified = true;
    }
}

