/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rapi.CorrelationSetModel;
import org.apache.ode.bpel.rapi.PropertyAliasModel;
import org.apache.ode.bpel.rapi.PropertyExtractor;
import org.apache.ode.bpel.rtrep.v1.OActivity;
import org.apache.ode.bpel.rtrep.v1.OBase;
import org.apache.ode.bpel.rtrep.v1.OCompensationHandler;
import org.apache.ode.bpel.rtrep.v1.OEventHandler;
import org.apache.ode.bpel.rtrep.v1.OExtVar;
import org.apache.ode.bpel.rtrep.v1.OFaultHandler;
import org.apache.ode.bpel.rtrep.v1.OPartnerLink;
import org.apache.ode.bpel.rtrep.v1.OProcess;
import org.apache.ode.bpel.rtrep.v1.OTerminationHandler;
import org.apache.ode.bpel.rtrep.v1.OVarType;

public class OScope
extends OActivity {
    static final long serialVersionUID = -1L;
    public String name;
    public OFaultHandler faultHandler;
    public OActivity activity;
    public OCompensationHandler compensationHandler;
    public OTerminationHandler terminationHandler;
    public OEventHandler eventHandler;
    public final HashMap<String, Variable> variables = new HashMap();
    public final Map<String, CorrelationSet> correlationSets = new HashMap<String, CorrelationSet>();
    public final Map<String, OPartnerLink> partnerLinks = new HashMap<String, OPartnerLink>();
    public final Set<OScope> compensatable = new HashSet<OScope>();
    public boolean implicitScope;
    public boolean atomicScope;

    public OScope(OProcess oProcess, OActivity oActivity) {
        super(oProcess, oActivity);
    }

    public CorrelationSet getCorrelationSet(String string) {
        return this.correlationSets.get(string);
    }

    public Variable getLocalVariable(String string) {
        return this.variables.get(string);
    }

    public void addLocalVariable(Variable variable) {
        this.variables.put(variable.name, variable);
    }

    public Variable getVisibleVariable(String string) {
        for (OActivity oActivity = this; oActivity != null; oActivity = oActivity.getParent()) {
            Variable variable;
            if (!(oActivity instanceof OScope) || (variable = oActivity.getLocalVariable(string)) == null) continue;
            return variable;
        }
        return null;
    }

    public OPartnerLink getLocalPartnerLink(String string) {
        return this.partnerLinks.get(string);
    }

    public OPartnerLink getVisiblePartnerLink(String string) {
        for (OActivity oActivity = this; oActivity != null; oActivity = oActivity.getParent()) {
            OPartnerLink oPartnerLink;
            if (!(oActivity instanceof OScope) || (oPartnerLink = oActivity.getLocalPartnerLink(string)) == null) continue;
            return oPartnerLink;
        }
        return null;
    }

    public void addCorrelationSet(CorrelationSet correlationSet) {
        this.correlationSets.put(correlationSet.name, correlationSet);
    }

    public boolean isInAtomicScope() {
        for (OActivity oActivity = this; oActivity != null; oActivity = oActivity.getParent()) {
            if (!(oActivity instanceof OScope) || !oActivity.atomicScope) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "{OScope '" + this.name + "' id=" + this.getId() + "}";
    }

    public static final class Variable
    extends OBase {
        static final long serialVersionUID = -1L;
        public String name;
        public OScope declaringScope;
        public OVarType type;
        public OExtVar extVar;

        public Variable(OProcess oProcess, OVarType oVarType) {
            super(oProcess);
            this.type = oVarType;
        }

        public String toString() {
            return "{Variable " + this.getDescription() + ":" + this.type + "}";
        }

        public String getDescription() {
            StringBuffer stringBuffer = new StringBuffer(this.declaringScope.name);
            stringBuffer.append('.');
            stringBuffer.append(this.name);
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CorrelationSet
    extends OBase
    implements CorrelationSetModel {
        static final long serialVersionUID = -1L;
        public String name;
        public OScope declaringScope;
        public final List<OProcess.OProperty> properties = new ArrayList<OProcess.OProperty>();

        public CorrelationSet(OProcess oProcess) {
            super(oProcess);
        }

        @Override
        public String toString() {
            return "{CSet " + this.name + " " + this.properties + "}";
        }

        public List<PropertyAliasModel> getAliases(QName qName) {
            ArrayList<PropertyAliasModel> arrayList = new ArrayList<PropertyAliasModel>();
            OVarType oVarType = this.getOwner().messageTypes.get(qName);
            for (OProcess.OProperty oProperty : this.properties) {
                OProcess.OProperty oProperty2 = oProperty;
                OProcess.OPropertyAlias oPropertyAlias = oProperty2.getAlias(oVarType);
                if (oPropertyAlias == null) {
                    throw new IllegalArgumentException("No alias found for property " + oProperty2.name + " and message " + qName + ", should have been caught at compilation.");
                }
                arrayList.add(oPropertyAlias);
            }
            return arrayList;
        }

        public List<PropertyExtractor> getExtractors() {
            return new ArrayList<PropertyExtractor>();
        }

        public boolean isUnique() {
            return false;
        }

        public void setUnique(boolean bl) {
        }
    }
}

