/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v1.channels;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.rapi.FaultInfo;
import org.apache.ode.bpel.rtrep.v1.OBase;
import org.apache.ode.bpel.rtrep.v1.OElementVarType;
import org.apache.ode.bpel.rtrep.v1.OMessageVarType;
import org.apache.ode.bpel.rtrep.v1.OVarType;
import org.apache.ode.utils.SerializableElement;
import org.w3c.dom.Element;

public class FaultData
implements Serializable,
FaultInfo {
    private static final long serialVersionUID = 1L;
    private QName _faultName;
    private OVarType _faultVarType;
    private SerializableElement _faultMsg;
    private OBase _location;
    private final String _explanation;

    public FaultData(QName qName, OBase oBase, String string) {
        this._faultName = qName;
        this._location = oBase;
        this._explanation = string;
    }

    public FaultData(QName qName, Element element, OVarType oVarType, OBase oBase) {
        this(qName, oBase, null);
        assert (element != null);
        assert (oVarType != null);
        assert (oVarType instanceof OMessageVarType || oVarType instanceof OElementVarType);
        this._faultMsg = new SerializableElement(element);
        this._faultVarType = oVarType;
    }

    public Element getFaultMessage() {
        return this._faultMsg == null ? null : this._faultMsg.getElement();
    }

    public OVarType getFaultType() {
        return this._faultVarType;
    }

    public QName getFaultName() {
        return this._faultName;
    }

    public int getFaultLineNo() {
        return this.findLineNo(this._location);
    }

    public String getExplanation() {
        return this._explanation;
    }

    public int getActivityId() {
        return this._location.getId();
    }

    protected int findLineNo(OBase oBase) {
        if (oBase == null) {
            return -1;
        }
        if (oBase.debugInfo == null) {
            return -1;
        }
        return oBase.debugInfo.startLine;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("FaultData: [faultName=");
        stringBuilder.append(this._faultName);
        stringBuilder.append(", faulType=");
        stringBuilder.append(this._faultVarType);
        if (this._explanation != null) {
            stringBuilder.append(" (");
            stringBuilder.append(this._explanation);
            stringBuilder.append(")");
        }
        stringBuilder.append("] @");
        stringBuilder.append(this.findLineNo(this._location));
        return stringBuilder.toString();
    }
}

