/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.id.dom;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.Key;
import org.eclipse.smila.utils.xml.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IdBuilder {
    public static final String NAMESPACE_ID = "http://www.eclipse.org/smila/id";
    public static final String ATTRIBUTE_XMLNSID = "xmlns";
    public static final String PREFIX_ID = "";
    public static final String TAG_ID = "Id";
    public static final String TAG_IDLIST = "IdList";
    public static final String TAG_SOURCE = "Source";
    public static final String TAG_KEY = "Key";
    public static final String TAG_ELEMENT = "Element";
    public static final String TAG_FRAGMENT = "Fragment";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String SCHEMA_VERSION_ID = "1.0";
    private boolean _printPretty;

    public IdBuilder() {
    }

    public IdBuilder(boolean printPretty) {
        this._printPretty = printPretty;
    }

    public Element appendId(Element element, Id id) {
        Document factory = element.getOwnerDocument();
        Element idElement = this.buildId(factory, id);
        idElement.setAttributeNS("http://www.w3.org/2000/xmlns/", ATTRIBUTE_XMLNSID, NAMESPACE_ID);
        this.newline(factory, element);
        element.appendChild(idElement);
        this.newline(factory, element);
        return idElement;
    }

    public Element appendId(Document document, Id id) {
        Element idElement = this.buildId(document, id);
        idElement.setAttributeNS("http://www.w3.org/2000/xmlns/", ATTRIBUTE_XMLNSID, NAMESPACE_ID);
        document.appendChild(idElement);
        return idElement;
    }

    public Element appendIdList(Element element, Iterable<Id> idList) {
        Document factory = element.getOwnerDocument();
        Element listElement = this.appendIdListElement(factory, element);
        for (Id id : idList) {
            Element idElement = this.buildId(factory, id);
            listElement.appendChild(idElement);
            this.newline(factory, listElement);
        }
        return listElement;
    }

    public Element appendIdList(Element element, Id[] idList) {
        Document factory = element.getOwnerDocument();
        Element listElement = this.appendIdListElement(factory, element);
        Id[] idArray = idList;
        int n = idList.length;
        int n2 = 0;
        while (n2 < n) {
            Id id = idArray[n2];
            Element idElement = this.buildId(factory, id);
            listElement.appendChild(idElement);
            this.newline(factory, listElement);
            ++n2;
        }
        return listElement;
    }

    public String idToString(Id id) throws ParserConfigurationException, IOException {
        if (id == null) {
            return PREFIX_ID;
        }
        Document document = XmlHelper.newDocument();
        Element idElement = this.buildId(document, id);
        document.appendChild(idElement);
        String xml = XmlHelper.toString((Document)document, (boolean)false);
        return xml;
    }

    private Element appendIdListElement(Document factory, Element element) {
        Element listElement = factory.createElementNS(NAMESPACE_ID, TAG_IDLIST);
        listElement.setAttributeNS("http://www.w3.org/2000/xmlns/", ATTRIBUTE_XMLNSID, NAMESPACE_ID);
        this.newline(factory, listElement);
        element.appendChild(listElement);
        return listElement;
    }

    private Element buildId(Document factory, Id id) {
        Element idElement = factory.createElementNS(NAMESPACE_ID, TAG_ID);
        idElement.setAttribute(ATTRIBUTE_VERSION, SCHEMA_VERSION_ID);
        this.newline(factory, idElement);
        this.appendTextElement(factory, idElement, TAG_SOURCE, id.getSource());
        Key sourceKey = id.getKey();
        this.appendKey(factory, idElement, sourceKey);
        if (id.hasElementKeys()) {
            Element elementElement = factory.createElementNS(NAMESPACE_ID, TAG_ELEMENT);
            idElement.appendChild(elementElement);
            this.newline(factory, idElement);
            this.newline(factory, elementElement);
            for (Key key : id.getElementKeys()) {
                this.appendKey(factory, elementElement, key);
                Element subElementElement = factory.createElementNS(NAMESPACE_ID, TAG_ELEMENT);
                this.newline(factory, subElementElement);
                elementElement.appendChild(subElementElement);
                this.newline(factory, elementElement);
                elementElement = subElementElement;
            }
        }
        if (id.hasFragmentNames()) {
            for (String fragment : id.getFragmentNames()) {
                this.appendTextElement(factory, idElement, TAG_FRAGMENT, fragment);
            }
        }
        return idElement;
    }

    private void appendKey(Document factory, Element element, Key key) {
        if (key.isCompositeKey()) {
            Iterator<String> keyNames = key.getKeyNames();
            while (keyNames.hasNext()) {
                String keyName = keyNames.next();
                this.appendKeyValue(factory, element, keyName, key.getKey(keyName));
            }
        } else {
            this.appendKeyValue(factory, element, key.getKeyName(), key.getKey());
        }
    }

    private void appendKeyValue(Document factory, Element element, String keyName, String keyValue) {
        Element keyElement = this.appendTextElement(factory, element, TAG_KEY, keyValue);
        if (keyName != null) {
            keyElement.setAttribute(ATTRIBUTE_NAME, keyName);
        }
    }

    private Element appendTextElement(Document factory, Element element, String name, String text) {
        Element textElement = factory.createElementNS(NAMESPACE_ID, name);
        textElement.appendChild(factory.createTextNode(text));
        element.appendChild(textElement);
        this.newline(factory, element);
        return textElement;
    }

    private void newline(Document factory, Element element) {
        if (this._printPretty) {
            element.appendChild(factory.createTextNode("\n"));
        }
    }
}

