/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.id.dom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.IdFactory;
import org.eclipse.smila.datamodel.id.Key;
import org.eclipse.smila.utils.xml.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IdParser {
    public static final String NAMESPACE_ID = "http://www.eclipse.org/smila/id";
    public static final String TAG_ID = "Id";
    public static final String TAG_IDLIST = "IdList";
    public static final String TAG_SOURCE = "Source";
    public static final String TAG_KEY = "Key";
    public static final String TAG_ELEMENT = "Element";
    public static final String TAG_FRAGMENT = "Fragment";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String ATTRIBUTE_NAME = "name";
    private final IdFactory _factory;

    public IdParser() {
        this._factory = IdFactory.DEFAULT_INSTANCE;
    }

    public IdParser(IdFactory customFactory) {
        this._factory = customFactory;
    }

    public Id parseIdIn(Element parentElement) {
        NodeList children = parentElement.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Element idElement;
                String localName;
                Node childNode = children.item(i);
                if (childNode instanceof Element && TAG_ID.equals(localName = (idElement = (Element)childNode).getLocalName())) {
                    return this.parseIdFrom(idElement);
                }
                ++i;
            }
        }
        return null;
    }

    public List<Id> parseIdsIn(Element parentElement) {
        NodeList children = parentElement.getChildNodes();
        ArrayList<Id> ids = new ArrayList<Id>();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Element idElement;
                Node childNode = children.item(i);
                if (childNode instanceof Element && TAG_ID.equals((idElement = (Element)childNode).getLocalName())) {
                    ids.add(this.parseIdFrom(idElement));
                }
                ++i;
            }
        }
        return ids;
    }

    public Id parseIdFrom(Element idElement) {
        NodeList nodes = idElement.getChildNodes();
        String source = null;
        HashMap<String, String> keyValues = new HashMap<String, String>();
        ArrayList<Key> elementKeys = new ArrayList<Key>();
        ArrayList<String> fragmentNames = new ArrayList<String>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                String elementName = element.getLocalName();
                if (TAG_SOURCE.equals(elementName)) {
                    source = element.getTextContent();
                } else if (TAG_KEY.equals(elementName)) {
                    this.parseKeyValue(keyValues, element);
                } else if (TAG_ELEMENT.equals(elementName)) {
                    this.parseElement(elementKeys, element);
                } else if (TAG_FRAGMENT.equals(elementName)) {
                    fragmentNames.add(element.getTextContent());
                }
            }
            ++i;
        }
        Key sourceKey = this._factory.createKey(keyValues);
        return this._factory.createId(source, sourceKey, elementKeys, fragmentNames);
    }

    public Id parseIdFrom(String xmlString) throws ParserConfigurationException, IOException, SAXException {
        Document document = XmlHelper.parse((String)xmlString);
        return this.parseIdFrom(document.getDocumentElement());
    }

    private void parseElement(List<Key> elementKeys, Element elementElement) {
        NodeList nodes = elementElement.getChildNodes();
        HashMap<String, String> elementKeyValues = new HashMap<String, String>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                Element subElement = (Element)node;
                String elementName = subElement.getLocalName();
                if (TAG_KEY.equals(elementName)) {
                    this.parseKeyValue(elementKeyValues, subElement);
                }
                if (TAG_ELEMENT.equals(elementName)) {
                    Key elementKey = this._factory.createKey(elementKeyValues);
                    elementKeys.add(elementKey);
                    this.parseElement(elementKeys, subElement);
                    return;
                }
            }
            ++i;
        }
    }

    private void parseKeyValue(Map<String, String> keyValues, Element element) {
        String keyName = element.getAttribute(ATTRIBUTE_NAME);
        if (StringUtils.isBlank((String)keyName)) {
            keyName = null;
        }
        keyValues.put(keyName, element.getTextContent());
    }
}

