/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.id.stax;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.IdFactory;
import org.eclipse.smila.datamodel.id.Key;

public class IdReader {
    private IdFactory _idFactory = IdFactory.DEFAULT_INSTANCE;

    public IdReader() {
    }

    public IdReader(IdFactory idFactory) {
        this();
        this._idFactory = idFactory;
    }

    public Id readId(XMLStreamReader staxReader) throws XMLStreamException {
        Id id = null;
        if (this.isStartTag(staxReader, "Id")) {
            ArrayList<Key> elementKeys = null;
            ArrayList<String> fragmentNames = null;
            staxReader.nextTag();
            String source = staxReader.getElementText();
            Key key = this.readKey(staxReader);
            if (this.isStartTag(staxReader, "Element")) {
                elementKeys = new ArrayList<Key>();
                while (this.isStartTag(staxReader, "Element")) {
                    Key elementKey = this.readKey(staxReader);
                    if (elementKey == null) continue;
                    elementKeys.add(elementKey);
                }
                while ("Element".equals(staxReader.getLocalName())) {
                    staxReader.nextTag();
                }
            }
            if (this.isStartTag(staxReader, "Fragment")) {
                fragmentNames = new ArrayList<String>();
                while (this.isStartTag(staxReader, "Fragment")) {
                    fragmentNames.add(staxReader.getElementText());
                    staxReader.nextTag();
                }
            }
            id = this._idFactory.createId(source, key, elementKeys, fragmentNames);
        }
        return id;
    }

    private Key readKey(XMLStreamReader staxReader) throws XMLStreamException {
        HashMap<String, String> keyValues = null;
        String value = null;
        String name = null;
        staxReader.nextTag();
        while (this.isStartTag(staxReader, "Key")) {
            if (keyValues == null && value != null) {
                keyValues = new HashMap<String, String>();
                keyValues.put(name, value);
            }
            name = staxReader.getAttributeValue(null, "name");
            value = staxReader.getElementText();
            if (keyValues != null) {
                keyValues.put(name, value);
            }
            staxReader.nextTag();
        }
        if (keyValues == null) {
            return this._idFactory.createKey(name, value);
        }
        return this._idFactory.createKey(keyValues);
    }

    private boolean isStartTag(XMLStreamReader staxReader, String tagName) {
        return staxReader.isStartElement() && tagName.equals(staxReader.getLocalName());
    }
}

