/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.record.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.id.IdFactory;
import org.eclipse.smila.datamodel.id.dom.IdParser;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.LiteralFormatHelper;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecordParser {
    public static final String NAMESPACE_RECORD = "http://www.eclipse.org/smila/record";
    public static final String TAG_RECORD = "Record";
    public static final String TAG_RECORDLIST = "RecordList";
    public static final String TAG_ATTRIBUTE = "A";
    public static final String TAG_ANNOTATION = "An";
    public static final String TAG_LITERAL = "L";
    public static final String TAG_OBJECT = "O";
    public static final String TAG_VALUE = "V";
    public static final String TAG_ATTACHMENT = "Attachment";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String ATTRIBUTE_NAME = "n";
    public static final String ATTRIBUTE_TYPE = "t";
    public static final String ATTRIBUTE_SEMANTICTYPE = "st";
    private final IdParser _idParser;
    private final RecordFactory _recordFactory;
    private final LiteralFormatHelper _literalHelper = new LiteralFormatHelper();

    public RecordParser() {
        this._idParser = new IdParser();
        this._recordFactory = RecordFactory.DEFAULT_INSTANCE;
    }

    public RecordParser(RecordFactory recordFactory, IdFactory idFactory) {
        this._idParser = new IdParser(idFactory);
        this._recordFactory = recordFactory;
    }

    public Record parseRecordIn(Element parentElement) {
        NodeList children = parentElement.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Element recordElement;
                Node childNode = children.item(i);
                if (childNode instanceof Element && TAG_RECORD.equals((recordElement = (Element)childNode).getLocalName())) {
                    return this.parseRecordFrom(recordElement);
                }
                ++i;
            }
        }
        return null;
    }

    public List<Record> parseRecordsIn(Element parentElement) {
        NodeList children = parentElement.getChildNodes();
        ArrayList<Record> records = new ArrayList<Record>();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Element recordElement;
                Node childNode = children.item(i);
                if (childNode instanceof Element && TAG_RECORD.equals((recordElement = (Element)childNode).getLocalName())) {
                    records.add(this.parseRecordFrom(recordElement));
                }
                ++i;
            }
        }
        return records;
    }

    public Record parseRecordFrom(Element recordElement) {
        Record record = this._recordFactory.createRecord();
        record.setId(this._idParser.parseIdIn(recordElement));
        record.setMetadata(this.parseMetadataObject(recordElement));
        this.parseAttachments(record, recordElement);
        return record;
    }

    public void parseAnnotation(Annotatable annotatable, Element annotationElement) {
        String annotationName = annotationElement.getAttribute(ATTRIBUTE_NAME);
        Annotation annotation = this._recordFactory.createAnnotation();
        NodeList children = annotationElement.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (childNode instanceof Element) {
                    Element childElement = (Element)childNode;
                    if (TAG_VALUE.equals(childElement.getLocalName())) {
                        String value = childElement.getTextContent();
                        String name = childElement.getAttribute(ATTRIBUTE_NAME);
                        if (StringUtils.isBlank((String)name)) {
                            annotation.addAnonValue(value);
                        } else {
                            annotation.setNamedValue(name, value);
                        }
                    } else if (TAG_ANNOTATION.equals(childElement.getLocalName())) {
                        this.parseAnnotation(annotation, childElement);
                    }
                }
                ++i;
            }
        }
        annotatable.addAnnotation(annotationName, annotation);
    }

    private MObject parseMetadataObject(Element element) {
        MObject mObject = this._recordFactory.createMetadataObject();
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (childNode instanceof Element) {
                    Element childElement = (Element)childNode;
                    if (TAG_ATTRIBUTE.equals(childElement.getLocalName())) {
                        this.parseAttribute(mObject, childElement);
                    } else if (TAG_ANNOTATION.equals(childElement.getLocalName())) {
                        this.parseAnnotation(mObject, childElement);
                    }
                }
                ++i;
            }
        }
        return mObject;
    }

    private void parseAttribute(MObject mObject, Element attributeElement) {
        String name = attributeElement.getAttribute(ATTRIBUTE_NAME);
        Attribute attribute = null;
        attribute = mObject.hasAttribute(name) ? mObject.getAttribute(name) : this._recordFactory.createAttribute();
        NodeList children = attributeElement.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (childNode instanceof Element) {
                    Element childElement = (Element)childNode;
                    if (TAG_LITERAL.equals(childElement.getLocalName())) {
                        this.parseLiterals(attribute, childElement);
                    } else if (TAG_OBJECT.equals(childElement.getLocalName())) {
                        this.parseAttributeObject(attribute, attributeElement, childElement);
                    } else if (TAG_ANNOTATION.equals(childElement.getLocalName())) {
                        this.parseAnnotation(attribute, childElement);
                    }
                }
                ++i;
            }
        }
        mObject.setAttribute(name, attribute);
    }

    private void parseAttributeObject(Attribute attribute, Element attributeElement, Element childElement) {
        MObject attributeMObject = this.parseMetadataObject(childElement);
        String semanticType = attributeElement.getAttribute(ATTRIBUTE_SEMANTICTYPE);
        if (!StringUtils.isBlank((String)semanticType)) {
            attributeMObject.setSemanticType(semanticType);
        }
        attribute.addObject(attributeMObject);
    }

    private void parseLiterals(Attribute attribute, Element literalsElement) {
        NodeList children;
        String defaultSemanticType = literalsElement.getAttribute(ATTRIBUTE_SEMANTICTYPE);
        if (StringUtils.isBlank((String)defaultSemanticType)) {
            defaultSemanticType = null;
        }
        if ((children = literalsElement.getChildNodes()) != null && children.getLength() > 0) {
            Literal annotationLiteral = null;
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                if (childNode instanceof Element) {
                    Element childElement = (Element)childNode;
                    if (TAG_VALUE.equals(childElement.getLocalName())) {
                        Literal newLiteral = this.parseAttributeLiteral(attribute, childElement, defaultSemanticType);
                        if (annotationLiteral == null) {
                            annotationLiteral = newLiteral;
                        }
                    } else if (annotationLiteral != null && TAG_ANNOTATION.equals(childElement.getLocalName())) {
                        this.parseAnnotation(annotationLiteral, childElement);
                    }
                }
                ++i;
            }
        }
    }

    private Literal parseAttributeLiteral(Attribute attribute, Element childElement, String defaultSemanticType) {
        Literal literal = this.parseLiteralValue(childElement);
        if (literal.getSemanticType() == null) {
            literal.setSemanticType(defaultSemanticType);
        }
        attribute.addLiteral(literal);
        return literal;
    }

    private Literal parseLiteralValue(Element literalElement) {
        Literal literal = this._recordFactory.createLiteral();
        String semanticType = literalElement.getAttribute(ATTRIBUTE_SEMANTICTYPE);
        if (!StringUtils.isBlank((String)semanticType)) {
            literal.setSemanticType(semanticType);
        }
        String dataType = literalElement.getAttribute(ATTRIBUTE_TYPE);
        String stringValue = literalElement.getTextContent();
        if (StringUtils.isBlank((String)dataType)) {
            literal.setStringValue(stringValue);
        } else {
            try {
                if ("int".equals(dataType)) {
                    literal.setIntValue(Long.valueOf(stringValue));
                } else if ("fp".equals(dataType)) {
                    literal.setFpValue(Double.valueOf(stringValue));
                } else if ("bool".equals(dataType)) {
                    literal.setBoolValue(Boolean.valueOf(stringValue));
                } else if ("date".equals(dataType)) {
                    literal.setDateValue(this._literalHelper.parseDate(stringValue));
                } else if ("time".equals(dataType)) {
                    literal.setTimeValue(this._literalHelper.parseTime(stringValue));
                } else if ("datetime".equals(dataType)) {
                    literal.setDateTimeValue(this._literalHelper.parseDateTime(stringValue));
                }
            }
            catch (ParseException parseException) {
                literal.setStringValue(stringValue);
            }
        }
        return literal;
    }

    private void parseAttachments(Record record, Element recordElement) {
        NodeList attachmentElements = recordElement.getElementsByTagNameNS(NAMESPACE_RECORD, TAG_ATTACHMENT);
        if (attachmentElements != null && attachmentElements.getLength() > 0) {
            int i = 0;
            while (i < attachmentElements.getLength()) {
                Element attachmentElement = (Element)attachmentElements.item(i);
                String attachmentName = attachmentElement.getTextContent();
                record.setAttachment(attachmentName, null);
                ++i;
            }
        }
    }
}

