/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.record.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.impl.AnnotatableImpl;
import org.eclipse.smila.datamodel.record.impl.LiteralImpl;
import org.eclipse.smila.datamodel.record.impl.MObjectImpl;

public class AttributeImpl
extends AnnotatableImpl
implements Attribute {
    private static final long serialVersionUID = 1L;
    private String _name;
    private List<LiteralImpl> _literalValues;
    private List<MObjectImpl> _metadataObjects;

    @Override
    public void addObject(MObject object) {
        if (object instanceof MObjectImpl) {
            if (this._metadataObjects == null) {
                this._metadataObjects = new ArrayList<MObjectImpl>();
            }
        } else {
            throw new IllegalArgumentException("Cannot add MObjects that are not instance of MObjectImpl.");
        }
        this._metadataObjects.add((MObjectImpl)object);
    }

    @Override
    public void addLiteral(Literal literal) {
        LiteralImpl literalImpl = LiteralImpl.ensureImpl(literal);
        if (this._literalValues == null) {
            this._literalValues = new ArrayList<LiteralImpl>();
        }
        this._literalValues.add(literalImpl);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public MObject getObject() {
        if (this.hasObjects()) {
            return this._metadataObjects.get(0);
        }
        return null;
    }

    @Override
    public List<MObject> getObjects() {
        if (this.hasObjects()) {
            return new ArrayList<MObject>(this._metadataObjects);
        }
        return Collections.emptyList();
    }

    @Override
    public Literal getLiteral() {
        if (this.hasLiterals()) {
            return this._literalValues.get(0);
        }
        return null;
    }

    @Override
    public List<Literal> getLiterals() {
        if (this.hasLiterals()) {
            return new ArrayList<Literal>(this._literalValues);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasObjects() {
        return this._metadataObjects != null && !this._metadataObjects.isEmpty();
    }

    @Override
    public boolean hasLiterals() {
        return this._literalValues != null && !this._literalValues.isEmpty();
    }

    @Override
    public int objectSize() {
        if (this.hasObjects()) {
            return this._metadataObjects.size();
        }
        return 0;
    }

    @Override
    public void removeObjects() {
        this._metadataObjects = null;
    }

    @Override
    public void removeLiterals() {
        this._literalValues = null;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void setObject(MObject object) {
        this.removeObjects();
        this.addObject(object);
    }

    @Override
    public void setObjects(Collection<? extends MObject> objects) {
        this.removeObjects();
        if (!objects.isEmpty()) {
            for (MObject mObject : objects) {
                this.addObject(mObject);
            }
        }
    }

    @Override
    public void setLiteral(Literal literal) {
        this.removeLiterals();
        this.addLiteral(literal);
    }

    @Override
    public void setLiterals(Collection<? extends Literal> literals) {
        this.removeLiterals();
        for (Literal literal : literals) {
            this.addLiteral(literal);
        }
    }

    @Override
    public int literalSize() {
        if (this.hasLiterals()) {
            return this._literalValues.size();
        }
        return 0;
    }
}

