/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.record.impl;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.smila.datamodel.record.InvalidTypeException;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.LiteralFormatHelper;
import org.eclipse.smila.datamodel.record.impl.AttributeValueImpl;

public class LiteralImpl
extends AttributeValueImpl
implements Literal {
    private static final long serialVersionUID = 1L;
    private Object _value;
    private Literal.DataType _dataType;

    public LiteralImpl() {
    }

    public LiteralImpl(Object value) throws InvalidTypeException {
        this.setValue(value);
    }

    public static LiteralImpl ensureImpl(Literal someLiteral) {
        if (someLiteral instanceof LiteralImpl) {
            return (LiteralImpl)someLiteral;
        }
        LiteralImpl literalImpl = new LiteralImpl();
        Object value = someLiteral.getValue();
        if (value != null) {
            try {
                literalImpl.setValue(value);
            }
            catch (InvalidTypeException e) {
                throw new IllegalArgumentException("Literal of class " + someLiteral.getClass().getName() + " returned illegal value object of class " + value.getClass(), e);
            }
        }
        return literalImpl;
    }

    @Override
    public Literal.DataType getDataType() {
        return this._dataType;
    }

    @Override
    public Boolean getBoolValue() {
        if (this._dataType == Literal.DataType.BOOL) {
            return (Boolean)this._value;
        }
        return null;
    }

    @Override
    public Date getDateTimeValue() {
        if (this._dataType == Literal.DataType.DATETIME) {
            return (Date)this._value;
        }
        return null;
    }

    @Override
    public Date getDateValue() {
        if (this._dataType == Literal.DataType.DATE) {
            return (Date)this._value;
        }
        return null;
    }

    @Override
    public Double getFpValue() {
        if (this._dataType == Literal.DataType.FP) {
            return (Double)this._value;
        }
        return null;
    }

    @Override
    public Long getIntValue() {
        if (this._dataType == Literal.DataType.INT) {
            return (Long)this._value;
        }
        return null;
    }

    @Override
    public String getStringValue() {
        if (this._value == null) {
            return null;
        }
        switch (this._dataType) {
            case STRING: {
                return (String)this._value;
            }
            case DATE: {
                return LiteralFormatHelper.INSTANCE.formatDate((Date)this._value);
            }
            case TIME: {
                return LiteralFormatHelper.INSTANCE.formatTime((Date)this._value);
            }
            case DATETIME: {
                return LiteralFormatHelper.INSTANCE.formatDateTime((Date)this._value);
            }
        }
        return this._value.toString();
    }

    @Override
    public Date getTimeValue() {
        if (this._dataType == Literal.DataType.TIME) {
            return (Date)this._value;
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this._value;
    }

    @Override
    public void setBoolValue(Boolean value) {
        this._value = value;
        this._dataType = Literal.DataType.BOOL;
    }

    @Override
    public void setDateTimeValue(Date value) {
        this._value = value;
        this._dataType = Literal.DataType.DATETIME;
    }

    @Override
    public void setDateValue(Date value) {
        this._value = value;
        this._dataType = Literal.DataType.DATE;
    }

    @Override
    public void setFpValue(Double value) {
        this._value = value;
        this._dataType = Literal.DataType.FP;
    }

    @Override
    public void setIntValue(Long value) {
        this._value = value;
        this._dataType = Literal.DataType.INT;
    }

    @Override
    public void setIntValue(Integer value) {
        this._value = value.longValue();
        this._dataType = Literal.DataType.INT;
    }

    @Override
    public void setStringValue(String value) {
        this._value = value;
        this._dataType = Literal.DataType.STRING;
    }

    @Override
    public void setTimeValue(Date value) {
        this._value = value;
        this._dataType = Literal.DataType.TIME;
    }

    @Override
    public void setValue(Object value) throws InvalidTypeException {
        if (value instanceof String) {
            this.setStringValue((String)value);
        } else if (value instanceof Double) {
            this.setFpValue((Double)value);
        } else if (value instanceof Float | value instanceof BigDecimal) {
            this.setFpValue(((Number)value).doubleValue());
        } else if (value instanceof Long) {
            this.setIntValue((Long)value);
        } else if (value instanceof Number) {
            this.setIntValue(((Number)value).longValue());
        } else if (value instanceof Boolean) {
            this.setBoolValue((Boolean)value);
        } else if (value instanceof Date) {
            this.setDateTimeValue((Date)value);
        } else {
            throw new InvalidTypeException("Cannot use instance of " + value.getClass() + " as literal value.");
        }
    }

    public String toString() {
        if (this._value == null) {
            return "(void)";
        }
        return this._value.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LiteralImpl) {
            LiteralImpl otherLit = (LiteralImpl)obj;
            if (this._value == null) {
                return otherLit._value == null;
            }
            return this._dataType == otherLit._dataType && this._value.equals(otherLit._value);
        }
        return false;
    }

    public int hashCode() {
        if (this._value == null) {
            return 0;
        }
        return this._dataType.hashCode() + this._value.hashCode();
    }
}

