/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.cmd.task.impl;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.jmx.client.cmd.task.Task;
import org.eclipse.smila.management.jmx.client.config.CustomType;
import org.eclipse.smila.management.jmx.client.exceptions.OperationException;
import org.eclipse.smila.management.jmx.client.helpers.JmxConnection;
import org.eclipse.smila.management.jmx.client.helpers.ParameterFormatHelper;

public class CustomTask
implements Task<CustomType> {
    private final Log _log = LogFactory.getLog(this.getClass());

    @Override
    public Object execute(CustomType config, JmxConnection connection, Object globalResult, String[] parameters, Object localResult) throws OperationException {
        Object result;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ParameterFormatHelper.format(config.getEcho(), globalResult, parameters, localResult));
        }
        try {
            Constructor<?> constructor = Class.forName(config.getClazz()).getConstructor(new Class[0]);
            Task task = (Task)constructor.newInstance(new Object[0]);
            result = task.execute(config, connection, globalResult, parameters, localResult);
        }
        catch (Throwable e) {
            throw new OperationException(e);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Custom task successfully executed");
        }
        return result;
    }
}

