/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.helpers;

import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.smila.management.jmx.client.config.ConnectionConfigType;
import org.eclipse.smila.management.jmx.client.exceptions.JmxConnectionException;
import org.eclipse.smila.management.jmx.client.exceptions.JmxInvocationException;

public class JmxConnection {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 9004;
    private MBeanServerConnection _mbeanServerConnection;
    private String _host = "localhost";
    private int _port = 9004;

    public JmxConnection(ConnectionConfigType connection) {
        if (connection != null) {
            this._host = connection.getHost();
            this._port = connection.getPort();
        }
    }

    public void connect() throws JmxConnectionException {
        try {
            JMXServiceURL jmxUrl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this._host + ":" + this._port + "/jmxrmi");
            this._mbeanServerConnection = JMXConnectorFactory.connect(jmxUrl).getMBeanServerConnection();
        }
        catch (Exception exception) {
            throw new JmxConnectionException(exception);
        }
    }

    public Object invoke(String domain, String key, String operation, Object[] arguments, String[] signature) throws JmxInvocationException {
        try {
            ObjectName objectName = this.prepareObjectName(domain, key);
            return this._mbeanServerConnection.invoke(objectName, operation, arguments, signature);
        }
        catch (Throwable e) {
            throw new JmxInvocationException(e);
        }
    }

    public Object getAttribute(String domain, String key, String attribute) throws JmxInvocationException {
        try {
            ObjectName objectName = this.prepareObjectName(domain, key);
            return this._mbeanServerConnection.getAttribute(objectName, attribute);
        }
        catch (Throwable e) {
            throw new JmxInvocationException(e);
        }
    }

    private ObjectName prepareObjectName(String domain, String key) throws MalformedObjectNameException {
        if (!key.contains("=")) {
            String[] parts = key.split("/");
            key = "";
            for (int i = 0; i < parts.length - 1; ++i) {
                key = key + String.format("C%d=%s,", i, parts[i]);
            }
            key = key + "Agent=" + parts[parts.length - 1];
        }
        return new ObjectName(domain + ":" + key);
    }
}

