/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.crawler.web.auth.HtmlFormAuthentication;
import org.eclipse.smila.connectivity.framework.crawler.web.filter.FilterProcessor;
import org.eclipse.smila.connectivity.framework.crawler.web.http.Http;
import org.eclipse.smila.connectivity.framework.crawler.web.http.HttpBase;
import org.eclipse.smila.connectivity.framework.crawler.web.http.Response;
import org.eclipse.smila.connectivity.framework.crawler.web.metadata.Metadata;
import org.eclipse.smila.connectivity.framework.crawler.web.util.RequestUtil;

public class HttpResponse
implements Response {
    private static final Log LOG = LogFactory.getLog(HttpResponse.class);
    private final HttpBase _http;
    private int _statusCode;
    private String _urlString;
    private final Metadata _headers;
    private byte[] _content;

    public HttpResponse(HttpBase http, String urlString, FilterProcessor filterProcessor) throws IOException {
        block20: {
            this._headers = new Metadata();
            this._http = http;
            this._urlString = urlString;
            HttpMethodBase httpMethod = null;
            try {
                try {
                    httpMethod = this.getHttpMethod();
                    this.setHttpParameters(http, httpMethod);
                    this._statusCode = Http.getClient().executeMethod((HttpMethod)httpMethod);
                    Header[] headers = httpMethod.getResponseHeaders();
                    int i = 0;
                    while (i < headers.length) {
                        this._headers.set(headers[i].getName(), headers[i].getValue());
                        ++i;
                    }
                    boolean contentTypeMatches = true;
                    String contentType = this._headers.get("Content-Type");
                    if (contentType != null && filterProcessor != null) {
                        contentTypeMatches = filterProcessor.evaluateContentTypeFilters(contentType);
                        LOG.debug((Object)("Content type header: " + contentType + ", passed filters: " + contentTypeMatches));
                    }
                    if (contentTypeMatches) {
                        block19: {
                            try {
                                InputStream in = httpMethod.getResponseBodyAsStream();
                                byte[] buffer = new byte[8192];
                                int totalRead = 0;
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                int tryAndRead = this.calculateTryToRead(totalRead);
                                int bufferFilled = in.read(buffer, 0, buffer.length);
                                while (bufferFilled != -1 && tryAndRead > 0) {
                                    out.write(buffer, 0, bufferFilled);
                                    tryAndRead = this.calculateTryToRead(totalRead += bufferFilled);
                                    bufferFilled = in.read(buffer, 0, buffer.length);
                                }
                                this._content = out.toByteArray();
                                in.close();
                            }
                            catch (HttpException exception) {
                                LOG.error((Object)"Http error occured ", (Throwable)exception);
                                throw new IOException(exception.toString());
                            }
                            catch (IOException exception) {
                                if (this._statusCode != 200) break block19;
                                throw new IOException(exception.toString());
                            }
                        }
                        if (this._content != null) {
                            String contentEncoding = this._headers.get("Content-Encoding");
                            if ("gzip".equals(contentEncoding) || "x-gzip".equals(contentEncoding)) {
                                this._content = http.processGzipEncoded(this._content, urlString);
                            }
                            if ("application/x-gzip".equals(contentType) || "application/gzip".equals(contentType)) {
                                this._content = http.processGzipEncoded(this._content, urlString);
                            }
                        }
                        break block20;
                    }
                    this._statusCode = -1;
                }
                catch (ProtocolException exception) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)exception);
                    }
                    throw new IOException(exception.toString());
                }
                catch (URISyntaxException exception) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)exception);
                    }
                    throw new IOException(exception.toString());
                }
            }
            finally {
                if (httpMethod != null) {
                    httpMethod.releaseConnection();
                }
            }
        }
    }

    private int calculateTryToRead(int totalRead) {
        int tryToRead = 8192;
        if (this._http.getMaxLengthBytes() <= 0) {
            return 8192;
        }
        if (this._http.getMaxLengthBytes() - totalRead < 8192) {
            tryToRead = this._http.getMaxLengthBytes() - totalRead;
        }
        return tryToRead;
    }

    private HttpMethodBase getHttpMethod() throws IOException, URISyntaxException {
        URI uri;
        try {
            uri = new URI(this._urlString);
        }
        catch (URISyntaxException uRISyntaxException) {
            uri = new URI(URIUtil.encodePathQuery((String)this._urlString));
        }
        List<HtmlFormAuthentication> authentications = this._http._authentication.getHtmlFormAuthentications();
        for (HtmlFormAuthentication auth : authentications) {
            if (!auth.getCredentialDomain().equals(uri.toString())) continue;
            GetMethod getMethod = new GetMethod(uri.toString());
            this.setHttpParameters(this._http, (HttpMethodBase)getMethod);
            try {
                try {
                    int result = Http.getClient().executeMethod((HttpMethod)getMethod);
                    LOG.debug((Object)("Response status code from login page: " + result));
                }
                catch (ProtocolException exception) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)exception);
                    }
                    throw new IOException(exception.toString());
                }
            }
            finally {
                getMethod.releaseConnection();
            }
            authentications.remove(auth);
            return this.getAuthenticationMethod(auth);
        }
        try {
            return new GetMethod(uri.toString());
        }
        catch (IllegalArgumentException exception) {
            throw new IOException("Can't get method. " + exception.getMessage());
        }
    }

    private HttpMethodBase getAuthenticationMethod(HtmlFormAuthentication auth) {
        PostMethod authenticationMethod = null;
        if (auth.getHttpMethod().equals((Object)HtmlFormAuthentication.HttpMethod.POST)) {
            PostMethod postMethod = new PostMethod(auth.getLoginUri());
            NameValuePair[] postData = new NameValuePair[auth.getFormItems().size()];
            int i = 0;
            for (String key : auth.getFormItems().keySet()) {
                postData[i] = new NameValuePair(key, auth.getFormItems().get(key));
                ++i;
            }
            postMethod.addParameters(postData);
            authenticationMethod = postMethod;
        } else if (auth.getHttpMethod().equals((Object)HtmlFormAuthentication.HttpMethod.GET)) {
            String requestString = RequestUtil.appendParams(auth.getLoginUri(), auth.getFormItems());
            LOG.debug((Object)("GET request string for authentication: " + requestString));
            GetMethod getMethod = new GetMethod(requestString);
            authenticationMethod = getMethod;
        }
        return authenticationMethod;
    }

    private void setHttpParameters(HttpBase http, HttpMethodBase httpMethod) {
        httpMethod.setFollowRedirects(false);
        httpMethod.setRequestHeader("User-Agent", http.getUserAgent());
        httpMethod.setRequestHeader("Referer", http.getReferer());
        httpMethod.setDoAuthentication(true);
        for (Header header : http.getHeaders()) {
            httpMethod.addRequestHeader(header);
        }
        HttpMethodParams params = httpMethod.getParams();
        if (http.getUseHttp11()) {
            params.setVersion(HttpVersion.HTTP_1_1);
        } else {
            params.setVersion(HttpVersion.HTTP_1_0);
        }
        params.makeLenient();
        params.setContentCharset("UTF-8");
        if (http.isCookiesEnabled()) {
            params.setCookiePolicy("compatibility");
        } else {
            params.setCookiePolicy("ignoreCookies");
        }
        params.setBooleanParameter("http.protocol.single-cookie-header", true);
        params.setParameter("http.method.retry-handler", null);
    }

    @Override
    public String getUrl() {
        return this._urlString;
    }

    @Override
    public int getCode() {
        return this._statusCode;
    }

    @Override
    public String getHeader(String name) {
        return this._headers.get(name);
    }

    @Override
    public Metadata getHeaders() {
        return this._headers;
    }

    @Override
    public byte[] getContent() {
        return this._content;
    }
}

