/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.crawler.web.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class GZIPUtils {
    private static final Log LOG = LogFactory.getLog(GZIPUtils.class);
    private static final int EXPECTED_COMPRESSION_RATIO = 5;
    private static final int BUF_SIZE = 4096;

    private GZIPUtils() {
    }

    public static byte[] unzipBestEffort(byte[] in) {
        return GZIPUtils.unzipBestEffort(in, Integer.MAX_VALUE);
    }

    public static byte[] unzipBestEffort(byte[] in, int sizeLimit) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(5 * in.length);
            GZIPInputStream inStream = new GZIPInputStream(new ByteArrayInputStream(in));
            byte[] buf = new byte[4096];
            int written = 0;
            try {
                int size;
                while ((size = inStream.read(buf)) > 0) {
                    if (written + size > sizeLimit) {
                        outStream.write(buf, 0, sizeLimit - written);
                        break;
                    }
                    outStream.write(buf, 0, size);
                    written += size;
                }
            }
            catch (IOException iOException) {}
            try {
                outStream.close();
            }
            catch (IOException iOException) {}
            return outStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static byte[] unzip(byte[] in) throws IOException {
        int size;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(5 * in.length);
        GZIPInputStream inStream = new GZIPInputStream(new ByteArrayInputStream(in));
        byte[] buf = new byte[4096];
        while ((size = inStream.read(buf)) > 0) {
            outStream.write(buf, 0, size);
        }
        outStream.close();
        return outStream.toByteArray();
    }

    public static byte[] zip(byte[] in) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(in.length / 5);
            GZIPOutputStream outStream = new GZIPOutputStream(byteOut);
            try {
                outStream.write(in);
            }
            catch (Exception exception) {
                LOG.error((Object)exception.getMessage());
            }
            try {
                outStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage());
            }
            return byteOut.toByteArray();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
            return null;
        }
    }
}

