/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.search.api.helper.AnnotationListAccessor;

public class HighlightInfo {
    private String _attributeName;
    private Annotation _annotation;
    private AnnotationListAccessor _positionHelper;

    public HighlightInfo(String attributeName, Annotation annotation) {
        this._attributeName = attributeName;
        this._annotation = annotation;
        this._positionHelper = new AnnotationListAccessor(attributeName, this._annotation.getAnnotations("positions"));
    }

    public String getAttributeName() {
        return this._attributeName;
    }

    public String getProperty(String name) {
        return this._annotation.getNamedValue(name);
    }

    public String getText() {
        return this._annotation.getNamedValue("text");
    }

    public boolean isHighlighted() {
        return this.positionLength() == 0;
    }

    public int positionLength() {
        return this._positionHelper.length();
    }

    public Integer getStartPos(int index) {
        return this._positionHelper.getIntProperty(index, "start");
    }

    public Integer getEndPos(int index) {
        return this._positionHelper.getIntProperty(index, "end");
    }

    public Double getQuality(int index) {
        return this._positionHelper.getFloatProperty(index, "quality");
    }

    public Integer getQueryGroup(int index) {
        return this._positionHelper.getIntProperty(index, "group");
    }

    public String getMethod(int index) {
        return this._positionHelper.getProperty(index, "method");
    }

    public String getProperty(int index, String name) {
        return this._positionHelper.getProperty(index, name);
    }

    public Annotation getSource() {
        return this._annotation;
    }
}

