/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.search.api.helper.RecordAccessor;

public class ParameterAnnotation {
    private Record _record;
    private Annotation _annotation;

    public ParameterAnnotation(Record record) {
        this._record = record;
    }

    public Annotation getAnnotation() {
        if (this._annotation == null) {
            if (this._record.getMetadata().hasAnnotation("parameters")) {
                this._annotation = this._record.getMetadata().getAnnotation("parameters");
            } else {
                this._annotation = this._record.getFactory().createAnnotation();
                this._record.getMetadata().setAnnotation("parameters", this._annotation);
            }
        }
        return this._annotation;
    }

    public void setParameter(String name, String value) {
        this.getAnnotation().setNamedValue(name, value);
    }

    public void setIntParameter(String name, int value) {
        this.setParameter(name, Integer.toString(value));
    }

    public void setFloatParameter(String name, double value) {
        this.setParameter(name, Double.toString(value));
    }

    public void setBooleanParameter(String name, boolean value) {
        this.setParameter(name, Boolean.toString(value));
    }

    public String getParameter(String name) {
        return this.getAnnotation().getNamedValue(name);
    }

    public Integer getIntParameter(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Double getFloatParameter(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Boolean getBooleanParameter(String name) {
        String value = this.getParameter(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public void setParameters(String name, Collection<String> values) {
        Annotation listParameter = this._record.getFactory().createAnnotation();
        listParameter.setAnonValues(values);
        this.getAnnotation().setAnnotation(name, listParameter);
    }

    public void addParameter(String name, String value) {
        Annotation listParameter = this.getAnnotation().getAnnotation(name);
        if (listParameter == null) {
            this.setParameters(name, Collections.singleton(value));
        } else {
            listParameter.addAnonValue(value);
        }
    }

    public List<String> getParameters(String name) {
        Annotation listParameter = this.getAnnotation().getAnnotation(name);
        if (listParameter == null) {
            return Collections.EMPTY_LIST;
        }
        Collection values = listParameter.getAnonValues();
        return RecordAccessor.unmodifiableList(values);
    }

    public List<Annotation> getSubAnnotations(String name) {
        return RecordAccessor.unmodifiableList(this.getAnnotation().getAnnotations(name));
    }
}

