/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import java.net.InetAddress;
import java.util.Date;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.id.IdFactory;
import org.eclipse.smila.datamodel.record.Annotatable;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.InvalidTypeException;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.LiteralFormatHelper;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.SearchAnnotations;
import org.eclipse.smila.processing.parameters.SearchParameters;
import org.eclipse.smila.search.api.SearchResult;
import org.eclipse.smila.search.api.SearchService;
import org.eclipse.smila.search.api.helper.Facets;
import org.eclipse.smila.search.api.helper.ParameterAnnotation;
import org.eclipse.smila.search.api.helper.ResultAccessor;
import org.w3c.dom.Document;

public class QueryBuilder {
    private static String s_localhostIP;
    private String _workflowName;
    private Record _query;
    private ParameterAnnotation _parameters;
    private LiteralFormatHelper _literalFormat;

    static {
        try {
            s_localhostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
        }
    }

    public QueryBuilder(String workflowName) {
        this(workflowName, RecordFactory.DEFAULT_INSTANCE.createRecord());
    }

    public QueryBuilder(String workflowName, RecordFactory factory) {
        this(workflowName, factory.createRecord());
    }

    public QueryBuilder(String workflowName, Record query) {
        this._workflowName = workflowName;
        this._query = query;
        this._parameters = new ParameterAnnotation(query);
    }

    public QueryBuilder setId(Id id) {
        this._query.setId(id);
        return this;
    }

    public QueryBuilder setQuery(String queryString) {
        this._parameters.setParameter("query", queryString);
        return this;
    }

    public QueryBuilder setResultSize(int size) {
        this._parameters.setIntParameter("resultSize", size);
        return this;
    }

    public QueryBuilder setResultOffset(int offset) {
        this._parameters.setIntParameter("resultOffset", offset);
        return this;
    }

    public QueryBuilder setThreshold(double threshold) {
        this._parameters.setFloatParameter("threshold", threshold);
        return this;
    }

    public QueryBuilder setLanguage(String language) {
        this._parameters.setParameter("language", language);
        return this;
    }

    public QueryBuilder setIndexName(String indexName) {
        this._parameters.setParameter("indexName", indexName);
        return this;
    }

    public QueryBuilder addLiteral(String attributeName, Object value) throws InvalidTypeException {
        Literal literal = this._query.getFactory().createLiteral();
        literal.setValue(value);
        return this.addLiteral(attributeName, literal);
    }

    public QueryBuilder addLiteral(String attributeName, Literal literal) {
        Attribute attribute = this.getAttribute(attributeName);
        attribute.addLiteral(literal);
        return this;
    }

    public QueryBuilder addEnumFilter(String attributeName, SearchAnnotations.FilterMode mode, Iterable<? extends Object> filterValues) throws InvalidTypeException {
        Annotation filter = this._query.getFactory().createAnnotation();
        filter.setNamedValue("type", SearchAnnotations.FilterType.ENUMERATION.toString());
        filter.setNamedValue("mode", mode.toString());
        for (Object object : filterValues) {
            String value = this.getStringValue(object);
            filter.addAnonValue(value);
        }
        this.addFilterAnnotation(attributeName, filter);
        return this;
    }

    public QueryBuilder addRangeFilter(String attributeName, SearchAnnotations.FilterMode mode, Object lowerBound, Object upperBound) throws InvalidTypeException {
        Annotation filter = this._query.getFactory().createAnnotation();
        filter.setNamedValue("type", SearchAnnotations.FilterType.RANGE.toString());
        filter.setNamedValue("mode", mode.toString());
        if (lowerBound != null) {
            String minValue = this.getStringValue(lowerBound);
            filter.setNamedValue("min", minValue);
        }
        if (upperBound != null) {
            String maxValue = this.getStringValue(upperBound);
            filter.setNamedValue("max", maxValue);
        }
        this.addFilterAnnotation(attributeName, filter);
        return this;
    }

    public QueryBuilder addFacetFilter(Facets facetList, int index) {
        Annotation filter = facetList.getObjectFilter(index);
        if (filter != null) {
            String attributeName = facetList.getAttributeName();
            this.addFilterAnnotation(attributeName, filter);
        } else {
            String textFilter = facetList.getStringFilter(index);
            if (textFilter != null) {
                String query = this._parameters.getParameter("query");
                query = query == null ? textFilter : String.valueOf(query) + textFilter;
                this.setQuery(query);
            }
        }
        return this;
    }

    public QueryBuilder addOrderBy(String attribute, SearchParameters.OrderMode mode) {
        Annotation paramAnno = this._parameters.getAnnotation();
        Annotation orderBy = this._query.getFactory().createAnnotation();
        orderBy.setNamedValue("attribute", attribute);
        orderBy.setNamedValue("mode", mode.toString());
        paramAnno.addAnnotation("orderBy", orderBy);
        return this;
    }

    public Annotation getRankingAnnotation(String attributeName) {
        Annotation ranking;
        MObject object = this._query.getMetadata();
        if (attributeName != null) {
            object = this.getAttribute(attributeName);
        }
        if ((ranking = object.getAnnotation("ranking")) == null) {
            ranking = this._query.getFactory().createAnnotation();
            object.setAnnotation("ranking", ranking);
        }
        return ranking;
    }

    public QueryBuilder setBoostFactor(String attributeName, double boost) {
        Annotation ranking = this.getRankingAnnotation(attributeName);
        ranking.setNamedValue("boost", Double.toString(boost));
        return this;
    }

    public QueryBuilder setRankingName(String attributeName, String rankingName) {
        Annotation ranking = this.getRankingAnnotation(attributeName);
        ranking.setNamedValue("name", rankingName);
        return this;
    }

    public QueryBuilder setParameter(String name, String value) {
        this._parameters.setParameter(name, value);
        return this;
    }

    public QueryBuilder addParameter(String name, String value) {
        this._parameters.addParameter(name, value);
        return this;
    }

    public QueryBuilder setAttachment(String name, byte[] attachment) {
        this._query.setAttachment(name, attachment);
        return this;
    }

    public ResultAccessor executeRequest(SearchService searchService) throws ProcessingException {
        this.ensureQueryId();
        SearchResult result = searchService.search(this._workflowName, this._query);
        return new ResultAccessor(result);
    }

    public Document executeRequestXml(SearchService searchService) throws ParserConfigurationException {
        this.ensureQueryId();
        return searchService.searchAsXml(this._workflowName, this._query);
    }

    public String executeRequestXmlString(SearchService searchService) throws ParserConfigurationException {
        this.ensureQueryId();
        return searchService.searchAsXmlString(this._workflowName, this._query);
    }

    public Record getQuery() {
        return this._query;
    }

    public String getWorkflowName() {
        return this._workflowName;
    }

    public ParameterAnnotation getParameters() {
        return this._parameters;
    }

    public QueryBuilder addAnnotationNamedValue(String attributeName, String[] pathElements, String valueName, String value) throws InvalidTypeException {
        Attribute annotatable = this.getAttribute(attributeName);
        String[] stringArray = pathElements;
        int n = pathElements.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            annotatable = this.ensureAnnotation((Annotatable)annotatable, path);
            ++n2;
        }
        ((Annotation)annotatable).setNamedValue(valueName, value);
        return this;
    }

    private Annotation ensureAnnotation(Annotatable annotatable, String name) {
        if (annotatable.hasAnnotation(name)) {
            return annotatable.getAnnotation(name);
        }
        Annotation annotation = this._query.getFactory().createAnnotation();
        annotatable.addAnnotation(name, annotation);
        return annotation;
    }

    private Attribute getAttribute(String attributeName) {
        Attribute attribute = this._query.getMetadata().getAttribute(attributeName);
        if (attribute == null) {
            attribute = this._query.getFactory().createAttribute();
            this._query.getMetadata().setAttribute(attributeName, attribute);
        }
        return attribute;
    }

    private void addFilterAnnotation(String attributeName, Annotation filter) {
        Attribute attribute = this.getAttribute(attributeName);
        attribute.addAnnotation("filter", filter);
    }

    private String getStringValue(Object object) throws InvalidTypeException {
        if (object instanceof Date) {
            return this._literalFormat.formatDateTime((Date)object);
        }
        return object.toString();
    }

    private void ensureQueryId() {
        if (this._query.getId() == null) {
            String source = s_localhostIP;
            if (source == null) {
                source = this._workflowName;
            }
            String key = UUID.randomUUID().toString();
            Id id = IdFactory.DEFAULT_INSTANCE.createId(source, key);
            this.setId(id);
        }
    }
}

