/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.processing.parameters.SearchParameters;
import org.eclipse.smila.search.api.helper.Facets;
import org.eclipse.smila.search.api.helper.ParameterAnnotation;
import org.eclipse.smila.search.api.helper.RecordAccessor;

public class QueryRecordAccessor
extends RecordAccessor {
    private ParameterAnnotation _parameters;
    private LinkedHashMap<String, SearchParameters.OrderMode> _orderByCache;

    public QueryRecordAccessor(Record record) {
        super(record);
        this._parameters = new ParameterAnnotation(record);
    }

    public String getQuery() {
        return this._parameters.getParameter("query");
    }

    public Integer getResultSize() {
        return this._parameters.getIntParameter("resultSize");
    }

    public Integer getResultOffset() {
        return this._parameters.getIntParameter("resultOffset");
    }

    public Double getThreshold() {
        return this._parameters.getFloatParameter("threshold");
    }

    public String getLanguage() {
        return this._parameters.getParameter("language");
    }

    public String getIndexName() {
        return this._parameters.getParameter("indexName");
    }

    public Integer getTotalHits() {
        return this.getResultAnnotationIntValue("totalHits");
    }

    public Integer getIndexSize() {
        return this.getResultAnnotationIntValue("indexSize");
    }

    public Integer getSearchRuntime() {
        return this.getResultAnnotationIntValue("runtime");
    }

    public String getParameter(String name) {
        return this._parameters.getParameter(name);
    }

    public List<String> getParameters(String name) {
        return this._parameters.getParameters(name);
    }

    public Facets getFacets(String attributeName) {
        return new Facets(attributeName, this.getAnnotations(attributeName, "facets"));
    }

    public Iterator<String> getOrderByAttributeNames() {
        if (this._orderByCache == null) {
            this.createOrderByCache();
        }
        return this._orderByCache.keySet().iterator();
    }

    public SearchParameters.OrderMode getOrderMode(String attributeName) {
        if (this._orderByCache == null) {
            this.createOrderByCache();
        }
        return this._orderByCache.get(attributeName);
    }

    public Annotation getRankingAnnotation(String attributeName) {
        if (attributeName == null) {
            return this.getAnnotation("ranking");
        }
        return this.getAnnotation(attributeName, "ranking");
    }

    public Double getBoostFactor(String attributeName) {
        Annotation ranking = this.getRankingAnnotation(attributeName);
        if (ranking == null) {
            return null;
        }
        String boost = ranking.getNamedValue("boost");
        if (boost != null) {
            try {
                return Double.valueOf(boost);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public String getRankingName(String attributeName) {
        Annotation ranking = this.getRankingAnnotation(attributeName);
        if (ranking == null) {
            return null;
        }
        return ranking.getNamedValue("name");
    }

    private void createOrderByCache() {
        this._orderByCache = new LinkedHashMap();
        List<Annotation> annotations = this._parameters.getSubAnnotations("orderBy");
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                String attributeName = annotation.getNamedValue("attribute");
                String orderModeValue = annotation.getNamedValue("mode");
                SearchParameters.OrderMode orderMode = SearchParameters.OrderMode.valueOf((String)orderModeValue);
                if (attributeName == null || orderMode == null) continue;
                this._orderByCache.put(attributeName, orderMode);
            }
        }
    }
}

