/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.smila.datamodel.record.dom.RecordBuilder;
import org.eclipse.smila.search.api.SearchResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResultDocumentBuilder {
    private DocumentBuilderFactory _builderFactory;
    private final RecordBuilder _recordBuilder = new RecordBuilder();

    public ResultDocumentBuilder() {
        this._builderFactory = DocumentBuilderFactory.newInstance();
        this._builderFactory.setNamespaceAware(true);
    }

    public Document buildResult(SearchResult result) throws ParserConfigurationException {
        Document doc = this._builderFactory.newDocumentBuilder().newDocument();
        Element root = doc.createElementNS("http://www.eclipse.org/smila/search", "SearchResult");
        doc.appendChild(root);
        Element query = doc.createElementNS("http://www.eclipse.org/smila/search", "Query");
        root.appendChild(query);
        Element workflowName = doc.createElementNS("http://www.eclipse.org/smila/search", "Workflow");
        workflowName.appendChild(doc.createTextNode(result.getWorkflowName()));
        query.appendChild(workflowName);
        if (result.getQuery() != null) {
            query.appendChild(this._recordBuilder.buildRecord(doc, result.getQuery()));
        }
        if (result.getRecords() != null) {
            this._recordBuilder.appendRecordList(root, result.getRecords());
        }
        return doc;
    }

    public Document buildError(Exception ex) throws ParserConfigurationException {
        Document doc = this._builderFactory.newDocumentBuilder().newDocument();
        Element root = doc.createElementNS("http://www.eclipse.org/smila/search", "Error");
        doc.appendChild(root);
        Element errorMessage = doc.createElementNS("http://www.eclipse.org/smila/search", "Message");
        root.appendChild(errorMessage);
        Throwable cause = ex;
        String message = ex.getLocalizedMessage();
        while (cause.getCause() != null && cause.getCause() != cause) {
            if ((cause = cause.getCause()).getLocalizedMessage() == null || cause.getLocalizedMessage().length() <= 0) continue;
            message = cause.getLocalizedMessage();
        }
        errorMessage.appendChild(doc.createTextNode(message));
        Element errorDetails = doc.createElementNS("http://www.eclipse.org/smila/search", "Details");
        root.appendChild(errorDetails);
        StringWriter stacktrace = new StringWriter();
        PrintWriter writer = new PrintWriter(stacktrace);
        ex.printStackTrace(writer);
        writer.close();
        errorDetails.appendChild(doc.createTextNode(stacktrace.toString()));
        return doc;
    }
}

