/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.eclipse.smila.connectivity.queue.worker.config.BrokerConnectionType;
import org.eclipse.smila.connectivity.queue.worker.config.ConnectionsConfigType;
import org.eclipse.smila.connectivity.queue.worker.config.QueueConnectionType;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractQueueService;
import org.eclipse.smila.connectivity.queue.worker.internal.connection.BrokerConnectionAccess;
import org.eclipse.smila.connectivity.queue.worker.internal.connection.ConnectionWrapper;
import org.eclipse.smila.connectivity.queue.worker.jms.BrokerConnectionException;
import org.eclipse.smila.connectivity.queue.worker.jms.BrokerConnectionService;

public class BrokerConnectionServiceImpl
extends AbstractQueueService<ConnectionsConfigType>
implements BrokerConnectionService {
    private final Map<String, BrokerConnectionAccess> _connectionAccessMap = new HashMap<String, BrokerConnectionAccess>();
    private final Map<String, ConnectionWrapper> _connectionCache = Collections.synchronizedMap(new HashMap());

    public BrokerConnectionServiceImpl() {
        super("BrokerConnectionService");
    }

    @Override
    public String getConfigName() {
        return "QueueWorkerConnectionConfig.xml";
    }

    @Override
    public synchronized void start() {
        this._log.info((Object)this.msg("Starting..."));
        try {
            super.start();
            for (BrokerConnectionType connectionType : ((ConnectionsConfigType)this._config).getConnectionConfig()) {
                String id = connectionType.getId();
                if (this._connectionAccessMap.containsKey(id)) {
                    throw new RuntimeException(this.msg(String.format("Broker with ID %s already registered", id)));
                }
                this._connectionAccessMap.put(connectionType.getId(), new BrokerConnectionAccess(connectionType));
            }
            this._log.info((Object)this.msg("Started successfully"));
        }
        catch (RuntimeException e) {
            this._log.error((Object)this.msg("Error starting"), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        this._connectionAccessMap.clear();
        Map<String, ConnectionWrapper> map = this._connectionCache;
        synchronized (map) {
            Iterator<ConnectionWrapper> iterator = this._connectionCache.values().iterator();
            while (iterator.hasNext()) {
                ConnectionWrapper connection = iterator.next();
                try {
                    connection.stopInternal();
                }
                catch (Throwable e) {
                    this._log.error((Object)this.msg("While stopping JMS connection"), e);
                }
                try {
                    connection.closeInternal();
                }
                catch (Throwable e) {
                    this._log.error((Object)this.msg("While closing JMS connection"), e);
                }
                iterator.remove();
            }
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(QueueConnectionType connectionType, boolean cached) throws BrokerConnectionException {
        BrokerConnectionAccess access = this._connectionAccessMap.get(connectionType.getBrokerId());
        if (access == null) {
            throw new BrokerConnectionException("Unable to find broker with ID=" + connectionType.getBrokerId());
        }
        if (!cached) {
            try {
                return access.getConnection(connectionType);
            }
            catch (JMSException e) {
                throw new BrokerConnectionException(e);
            }
        }
        Connection connection = this._connectionCache.get(connectionType.getBrokerId());
        if (connection != null) {
            return connection;
        }
        Map<String, ConnectionWrapper> map = this._connectionCache;
        synchronized (map) {
            connection = this._connectionCache.get(connectionType.getBrokerId());
            if (connection != null) {
                return connection;
            }
            try {
                connection = access.getConnection(connectionType);
                connection.start();
            }
            catch (JMSException e) {
                throw new BrokerConnectionException(e);
            }
            ConnectionWrapper connectionWrapper = new ConnectionWrapper(connection);
            this._connectionCache.put(connectionType.getBrokerId(), connectionWrapper);
            connection = connectionWrapper;
        }
        return connection;
    }
}

