/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.queue.worker.internal.router;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.Message;
import org.eclipse.smila.connectivity.queue.worker.Operation;
import org.eclipse.smila.connectivity.queue.worker.Router;
import org.eclipse.smila.connectivity.queue.worker.RouterException;
import org.eclipse.smila.connectivity.queue.worker.config.RouterConfigType;
import org.eclipse.smila.connectivity.queue.worker.config.RouterRuleType;
import org.eclipse.smila.connectivity.queue.worker.internal.AbstractQueueService;
import org.eclipse.smila.connectivity.queue.worker.internal.ServicesAccessPoint;
import org.eclipse.smila.connectivity.queue.worker.internal.router.RouterRule;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.jms.MessageSelectorEvalHelper;

public class RouterImpl
extends AbstractQueueService<RouterConfigType>
implements Router {
    private final Set<RouterRule> _rules = new LinkedHashSet<RouterRule>();

    public RouterImpl() {
        super("Router");
    }

    @Override
    public String getConfigName() {
        return "QueueWorkerRouterConfig.xml";
    }

    @Override
    public synchronized void start() {
        this._log.info((Object)this.msg("Starting..."));
        HashSet<String> names = new HashSet<String>();
        try {
            super.start();
            for (RouterRuleType ruleConfig : ((RouterConfigType)this._config).getRule()) {
                if (names.contains(ruleConfig.getName())) {
                    throw new RouterException(String.format("Wrong configuration: rule name %s is not unique", ruleConfig.getName()));
                }
                names.add(ruleConfig.getName());
                this._rules.add(new RouterRule((ServicesAccessPoint)this, ruleConfig));
            }
            this._log.info((Object)this.msg(String.format("Started successfully, found %d rules", this._rules.size())));
        }
        catch (Throwable e) {
            this._log.error((Object)this.msg("Error starting"), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void stop() {
        this._rules.clear();
        super.stop();
    }

    /*
     * Unable to fully structure code
     */
    public Map<Id, Exception> route(Record[] records, Operation operation) throws RouterException {
        this.getProcessingLock().lock();
        errorMap = new HashMap<Id, Exception>();
        try {
            if (this.getTaskListExecutionService() == null) {
                throw new RouterException("Router is not active anymore.");
            }
            rulemap = new HashMap<RouterRule, HashMap<Record, Properties>>();
            var8_5 = records;
            var7_7 = records.length;
            var6_9 = 0;
            while (var6_9 < var7_7) {
                record = var8_5[var6_9];
                messageProperties = this.createMessageProperties(record, operation);
                message = this.prepareDummyMessage(record, messageProperties);
                foundRule = false;
                for (RouterRule rule : this._rules) {
                    if (!rule.isApplied(message)) continue;
                    recordPropertiesMap = (HashMap<Record, Properties>)rulemap.get(rule);
                    if (recordPropertiesMap == null) {
                        recordPropertiesMap = new HashMap<Record, Properties>();
                        rulemap.put(rule, recordPropertiesMap);
                    }
                    recordPropertiesMap.put(record, messageProperties);
                    foundRule = true;
                    break;
                }
                if (!foundRule) {
                    msg = "Unable to find rule for record " + record.getId();
                    if (this._log.isErrorEnabled()) {
                        this._log.error((Object)msg);
                    }
                    errorMap.put(record.getId(), (Exception)new RouterException(msg));
                }
                ++var6_9;
            }
            block7: for (RouterRule rule : rulemap.keySet()) {
                recordPropertiesMap = (Map)rulemap.get(rule);
                if (recordPropertiesMap == null || recordPropertiesMap.isEmpty()) continue;
                try {
                    rule.route(recordPropertiesMap);
                    continue;
                }
                catch (RouterException e) {
                    ** for (record : recordPropertiesMap.keySet())
                }
lbl-1000:
                // 1 sources

                {
                    if (this._log.isErrorEnabled()) {
                        this._log.error((Object)("Error while routing record " + record.getId()), (Throwable)e);
                    }
                    errorMap.put(record.getId(), (Exception)e);
                    continue;
lbl47:
                    // 1 sources

                }
            }
        }
        finally {
            this.getProcessingLock().unlock();
        }
        return errorMap;
    }

    private Message prepareDummyMessage(Record record, Properties messageProperties) throws RouterException {
        Message message = MessageSelectorEvalHelper.createDummyMessage();
        try {
            if (messageProperties != null) {
                Enumeration<?> propertyNames = messageProperties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String name = (String)propertyNames.nextElement();
                    message.setStringProperty(name, messageProperties.getProperty(name));
                }
            }
        }
        catch (Throwable e) {
            throw new RouterException(e);
        }
        return message;
    }

    private Properties createMessageProperties(Record record, Operation operation) {
        Properties properties = new Properties();
        properties.setProperty("Operation", operation.toString());
        if (record != null) {
            MObject mObject;
            if (record.getId() != null && record.getId().getSource() != null) {
                properties.setProperty("DataSourceID", record.getId().getSource());
            }
            if ((mObject = record.getMetadata()) != null && mObject.hasAnnotation("MessageProperties")) {
                Annotation messageProperties = mObject.getAnnotation("MessageProperties");
                Iterator propertyNames = messageProperties.getValueNames();
                while (propertyNames.hasNext()) {
                    String propertyValue;
                    String propertyName = (String)propertyNames.next();
                    if (propertyName == null || (propertyValue = messageProperties.getNamedValue(propertyName)) == null) continue;
                    properties.setProperty(propertyName, propertyValue);
                }
            }
        }
        return properties;
    }
}

