/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class QueryScope {
    private String _indexName;
    private int _start;
    private int _hits;
    private int _startSelection;
    private int _recordsToSelect;

    public QueryScope(String indexName, int start, int hits) {
        if (indexName == null) {
            throw new NullPointerException("parameter must not be null [indexName]");
        }
        this._indexName = indexName;
        this._start = start;
        this._hits = hits;
    }

    public QueryScope(String indexName, int start, int hits, int recordsToSelect, int startSelection) {
        if (indexName == null) {
            throw new NullPointerException("parameter must not be null [indexName]");
        }
        this._indexName = indexName;
        this._start = start;
        this._hits = hits;
        this._recordsToSelect = recordsToSelect;
        this._startSelection = startSelection;
    }

    public int getHits() {
        return this._hits;
    }

    public String getIndexName() {
        return this._indexName;
    }

    public int getStart() {
        return this._start;
    }

    public void addHits(int hitsToAdd) {
        this._hits += hitsToAdd;
    }

    public int getRecordsToSelect() {
        return this._recordsToSelect;
    }

    public void setRecordsToSelect(int toSelect) {
        this._recordsToSelect = toSelect;
    }

    public int getStartSelection() {
        return this._startSelection;
    }

    public void setStartSelection(int selection) {
        this._startSelection = selection;
    }

    public String toString() {
        String objectAsString = new ReflectionToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).toString();
        return objectAsString;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object != null && QueryScope.class.isAssignableFrom(object.getClass())) {
            QueryScope queryScope = (QueryScope)object;
            equals = new EqualsBuilder().append(this._hits, queryScope.getHits()).append((Object)this._indexName, (Object)queryScope.getHits()).append(this._recordsToSelect, queryScope.getRecordsToSelect()).append(this._start, queryScope.getStart()).append(this._startSelection, queryScope.getStartSelection()).isEquals();
        }
        return equals;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this._hits).append((Object)this._indexName).append(this._recordsToSelect).append(this._start).append(this._startSelection).toHashCode();
    }
}

