/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.agent.jobfile;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.framework.AbstractAgent;
import org.eclipse.smila.connectivity.framework.AgentException;
import org.eclipse.smila.connectivity.framework.agent.jobfile.JobFileHandler;
import org.eclipse.smila.connectivity.framework.agent.jobfile.JobFileReader;
import org.eclipse.smila.connectivity.framework.agent.jobfile.messages.Process;
import org.eclipse.smila.connectivity.framework.schema.config.interfaces.IAttribute;
import org.eclipse.smila.connectivity.framework.util.AgentThreadState;
import org.eclipse.smila.connectivity.framework.util.ConnectivityHashFactory;
import org.eclipse.smila.connectivity.framework.util.ConnectivityIdFactory;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Record;

public class JobFileAgent
extends AbstractAgent
implements JobFileHandler {
    private static final long MILLI_SECOND_MULTIPLIER = 1000L;
    private final Log _log = LogFactory.getLog(JobFileAgent.class);
    private long _updateInterval;
    private String _attachmentSeparator;
    private List<String> _jobFileUrls;
    private JobFileReader _jobFileReader;
    private HashSet<String> _idAttributeNames;
    private HashSet<String> _hashAttributeNames;
    private HashSet<String> _hashAttachmentNames;

    public JobFileAgent() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Creating JobFileAgent instance");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                block13: while (true) {
                    if (this.isStopThread()) {
                        return;
                    }
                    try {
                        Iterator<String> iterator = this._jobFileUrls.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                Thread.sleep(this._updateInterval);
                                continue block13;
                            }
                            String jobUrl = iterator.next();
                            try {
                                this._jobFileReader.readJobFile(new URL(jobUrl));
                            }
                            catch (XMLStreamException e) {
                                if (this._log.isErrorEnabled()) {
                                    this._log.error((Object)("Error while reading job file " + jobUrl), (Throwable)e);
                                }
                                this.getAgentState().setLastError((Throwable)e);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        if (!this._log.isDebugEnabled()) continue;
                        this._log.debug((Object)"JobFileAgent thread was interrupted", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                this.getAgentState().setLastError(t);
                this.getAgentState().setState(AgentThreadState.Aborted);
                throw new RuntimeException(t);
            }
        }
        finally {
            try {
                this.stopThread();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void add(Record record) {
        block4: {
            try {
                if (record.getId() == null) {
                    record.setId(this.createId(record));
                } else {
                    this.assertDataSource(record.getId());
                }
                String hash = this.createHash(record);
                this.getControllerCallback().add(this.getSessionId(), this.getConfig().getDeltaIndexing(), record, hash);
            }
            catch (Exception e) {
                if (!this._log.isErrorEnabled()) break block4;
                this._log.error((Object)("Error adding record " + record.getId()), (Throwable)e);
            }
        }
    }

    @Override
    public void delete(Id id) {
        block2: {
            try {
                this.assertDataSource(id);
                this.getControllerCallback().delete(this.getSessionId(), this.getConfig().getDeltaIndexing(), id);
            }
            catch (Exception e) {
                if (!this._log.isErrorEnabled()) break block2;
                this._log.error((Object)("Error deleting record " + id), (Throwable)e);
            }
        }
    }

    protected void initialize() throws AgentException {
        this._updateInterval = ((Process)this.getConfig().getProcess()).getUpdateInterval().longValue() * 1000L;
        this._jobFileUrls = ((Process)this.getConfig().getProcess()).getJobFileUrl();
        this._attachmentSeparator = ((Process)this.getConfig().getProcess()).getAttachmentSeparator();
        this._jobFileReader = new JobFileReader(this, this._attachmentSeparator);
        this._idAttributeNames = new HashSet();
        this._hashAttributeNames = new HashSet();
        this._hashAttachmentNames = new HashSet();
        for (IAttribute attribute : this.getConfig().getAttributes().getAttribute()) {
            if (attribute.isKeyAttribute()) {
                this._idAttributeNames.add(attribute.getName());
            }
            if (!attribute.isHashAttribute()) continue;
            if (attribute.isAttachment()) {
                this._hashAttachmentNames.add(attribute.getName());
                continue;
            }
            this._hashAttributeNames.add(attribute.getName());
        }
        if (this._idAttributeNames.isEmpty() && this._log.isWarnEnabled()) {
            this._log.warn((Object)"No key attribute is configured. Therfore only records with Id tags are processed correctly!");
        }
        if (this._hashAttributeNames.isEmpty() && this._hashAttachmentNames.isEmpty() && this._log.isWarnEnabled()) {
            this._log.warn((Object)"No hash attribute or attachment is configured. Without a hash delta indexing will never update the record if once added!");
        }
    }

    private void assertDataSource(Id id) throws AgentException {
        if (!this.getConfig().getDataSourceID().equals(id.getSource())) {
            throw new AgentException("Invalid dataSourceId in record id " + id + ". DataSourceId must be '" + this.getConfig().getDataSourceID() + "' and not '" + id.getSource() + "'");
        }
    }

    private String createHash(Record record) {
        ArrayList<Attribute> hashAttributes = new ArrayList<Attribute>();
        for (String attributeName : this._hashAttributeNames) {
            if (record.getMetadata().hasAttribute(attributeName)) {
                hashAttributes.add(record.getMetadata().getAttribute(attributeName));
                continue;
            }
            if (!this._log.isWarnEnabled()) continue;
            this._log.warn((Object)("Record " + record.getId() + " does not contain the configured hash attribute " + attributeName + ". Hash is created without this attribute."));
        }
        HashMap<String, byte[]> hashAttachments = new HashMap<String, byte[]>();
        for (String attachmentName : this._hashAttachmentNames) {
            if (record.hasAttachment(attachmentName)) {
                hashAttachments.put(attachmentName, record.getAttachment(attachmentName));
                continue;
            }
            if (!this._log.isWarnEnabled()) continue;
            this._log.warn((Object)("Record " + record.getId() + " does not contain the configured hash attachment " + attachmentName + ". Hash is created without this attachment."));
        }
        return ConnectivityHashFactory.getInstance().createHash(hashAttributes.toArray(new Attribute[hashAttributes.size()]), hashAttachments);
    }

    private Id createId(Record record) {
        ArrayList<Attribute> idAttributes = new ArrayList<Attribute>();
        for (String attributeName : this._idAttributeNames) {
            if (record.getMetadata().hasAttribute(attributeName)) {
                idAttributes.add(record.getMetadata().getAttribute(attributeName));
                continue;
            }
            if (!this._log.isWarnEnabled()) continue;
            this._log.warn((Object)("Record does not contain the configured id attribute " + attributeName + ". Id is created without this attribute."));
        }
        return ConnectivityIdFactory.getInstance().createId(this.getConfig().getDataSourceID(), idAttributes.toArray(new Attribute[idAttributes.size()]));
    }
}

