/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.framework.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingException;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingSessionException;
import org.eclipse.smila.connectivity.framework.Agent;
import org.eclipse.smila.connectivity.framework.AgentController;
import org.eclipse.smila.connectivity.framework.AgentState;
import org.eclipse.smila.connectivity.framework.State;
import org.eclipse.smila.connectivity.framework.impl.AbstractController;
import org.eclipse.smila.connectivity.framework.impl.JobIdHelper;
import org.eclipse.smila.connectivity.framework.schema.config.DataConnectionID;
import org.eclipse.smila.connectivity.framework.schema.config.DataSourceConnectionConfig;
import org.eclipse.smila.connectivity.framework.schema.config.DeltaIndexingType;
import org.eclipse.smila.connectivity.framework.util.AgentControllerCallback;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.osgi.service.component.ComponentContext;

public class AgentControllerImpl
extends AbstractController
implements AgentController,
AgentControllerCallback {
    private static final String BUNDLE_ID = "org.eclipse.smila.connectivity.framework";
    private final Log _log = LogFactory.getLog(AgentControllerImpl.class);
    private final RecordFactory _recordFactory = RecordFactory.DEFAULT_INSTANCE;
    private final Map<String, Agent> _activeAgents;
    private final Map<String, AgentState> _agentStates;

    public AgentControllerImpl() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Creating AgentControllerImpl");
        }
        this._activeAgents = new HashMap<String, Agent>();
        this._agentStates = new HashMap<String, AgentState>();
    }

    public int startAgent(String dataSourceId) throws ConnectivityException {
        if (dataSourceId == null) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Parameter dataSourceId is null");
            }
            throw new NullPointerException("Parameter dataSourceId is null");
        }
        if (this._activeAgents.containsKey(dataSourceId)) {
            throw new ConnectivityException("Can't start a new agent for DataSourceId '" + dataSourceId + "'. An agent is already started for it.");
        }
        try {
            DataSourceConnectionConfig configuration = this.getConfiguration(BUNDLE_ID, dataSourceId);
            Agent agent = this.createInstance(Agent.class, configuration.getDataConnectionID().getId());
            int jobId = agent.hashCode();
            AgentState agentState = new AgentState();
            agentState.setJobId(Integer.toString(jobId));
            this._agentStates.put(dataSourceId, agentState);
            String sessionId = null;
            if (this.doDeltaIndexing(configuration.getDeltaIndexing())) {
                sessionId = this.getDeltaIndexingManager().init(dataSourceId);
            }
            agent.start((AgentControllerCallback)this, agentState, configuration, sessionId);
            this._activeAgents.put(dataSourceId, agent);
            return jobId;
        }
        catch (ConnectivityException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error during start of agent using DataSourceId '" + dataSourceId + "'";
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new ConnectivityException(msg, (Throwable)e);
        }
    }

    public void stopAgent(String dataSourceId) throws ConnectivityException {
        if (dataSourceId == null) {
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)"Parameter dataSourceId is null");
            }
            throw new NullPointerException("Parameter dataSourceId is null");
        }
        Agent agent = this._activeAgents.get(dataSourceId);
        if (agent == null) {
            String msg = "Could not stop Agent for DataSourceId '" + dataSourceId + "'. No agent has been started for it.";
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg);
            }
            throw new ConnectivityException(msg);
        }
        try {
            agent.stop();
        }
        catch (Exception e) {
            String msg = "Error while stopping agent for DataSourceId '" + dataSourceId + "'";
            if (this._log.isErrorEnabled()) {
                this._log.error((Object)msg, (Throwable)e);
            }
            throw new ConnectivityException(msg, (Throwable)e);
        }
    }

    public boolean hasActiveAgents() throws ConnectivityException {
        return !this._activeAgents.isEmpty();
    }

    public Map<String, AgentState> getAgentTasksState() {
        HashMap<String, AgentState> states = new HashMap<String, AgentState>();
        states.putAll(this._agentStates);
        return states;
    }

    public Collection<String> getAvailableAgents() {
        return this.getAvailableFactories();
    }

    public Collection<String> getAvailableConfigurations() {
        return this.getConfigurations(BUNDLE_ID, DataConnectionID.DataConnectionType.AGENT);
    }

    public void add(String sessionId, DeltaIndexingType deltaIndexingType, Record record, String hash) {
        block7: {
            if (record != null) {
                JobIdHelper.setJobIdAnnotation(record, (State)this._agentStates.get(record.getId().getSource()));
                try {
                    boolean isUpdate = true;
                    if (this.doCheckForUpdate(deltaIndexingType)) {
                        isUpdate = this.getDeltaIndexingManager().checkForUpdate(sessionId, record.getId(), hash);
                    }
                    if (isUpdate) {
                        this.getConnectivityManager().add(new Record[]{record});
                        if (this.doDeltaIndexing(deltaIndexingType)) {
                            this.getDeltaIndexingManager().visit(sessionId, record.getId(), hash, false);
                        }
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!this._log.isErrorEnabled()) break block7;
                    String msg = "Error while adding record '" + record.getId() + "'";
                    this._log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public void delete(String sessionId, DeltaIndexingType deltaIndexingType, Id id) {
        block9: {
            if (id != null) {
                String dataSourceId = id.getSource();
                try {
                    Record record = this._recordFactory.createRecord();
                    JobIdHelper.setJobIdAnnotation(record, (State)this._agentStates.get(record.getId().getSource()));
                    this.getConnectivityManager().delete(new Record[]{record});
                    if (this.doDeltaDelete(deltaIndexingType)) {
                        this.getDeltaIndexingManager().delete(sessionId, id);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (ConnectivityException e) {
                    if (this._log.isErrorEnabled()) {
                        String msg = "Error while deleting records for DataSourceId '" + dataSourceId + "'";
                        this._log.error((Object)msg, (Throwable)e);
                    }
                }
                catch (DeltaIndexingSessionException e) {
                    if (this._log.isErrorEnabled()) {
                        String msg = "Error while deleting records for DataSourceId '" + dataSourceId + "'";
                        this._log.error((Object)msg, (Throwable)e);
                    }
                }
                catch (DeltaIndexingException e) {
                    if (!this._log.isErrorEnabled()) break block9;
                    String msg = "Error while deleting records for DataSourceId '" + dataSourceId + "'";
                    this._log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    public void unregister(String sessionId, DeltaIndexingType deltaIndexingType, String dataSourceId) {
        block3: {
            this._activeAgents.remove(dataSourceId);
            if (this.doDeltaIndexing(deltaIndexingType)) {
                try {
                    this.getDeltaIndexingManager().finish(sessionId);
                }
                catch (Exception e) {
                    if (!this._log.isErrorEnabled()) break block3;
                    String msg = "Error finishing delta indexing for DataSourceId '" + dataSourceId + "'";
                    this._log.error((Object)msg, (Throwable)e);
                }
            }
        }
    }

    private int deleteDelta(String sessionId, DeltaIndexingType deltaIndexingType, Id compoundId) {
        int count;
        block5: {
            count = 0;
            if (this.doDeltaDelete(deltaIndexingType)) {
                try {
                    Iterator it = this.getDeltaIndexingManager().obsoleteIdIterator(sessionId, compoundId);
                    if (it != null) {
                        while (it.hasNext()) {
                            Id id = (Id)it.next();
                            if (id == null) continue;
                            this.getDeltaIndexingManager().delete(sessionId, (Id)it.next());
                            ++count;
                        }
                    }
                }
                catch (Exception e) {
                    String msg = "Error during execution of deleteDelta for compoundId " + compoundId;
                    if (!this._log.isErrorEnabled()) break block5;
                    this._log.error((Object)msg, (Throwable)e);
                }
            }
        }
        return count;
    }

    protected void deactivate(ComponentContext context) throws Exception {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)"Deactivating AgentController");
        }
        this._lock.writeLock().lock();
        try {
            for (Map.Entry<String, Agent> entry : this._activeAgents.entrySet()) {
                try {
                    if (entry.getValue() == null) continue;
                    entry.getValue().stop();
                }
                catch (Exception e) {
                    if (!this._log.isErrorEnabled()) continue;
                    this._log.error((Object)("Error stopping Agent for data source " + entry.getKey()), (Throwable)e);
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }
}

