/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.processing.pipelets.ATransformationPipelet;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XMLUtils;
import org.w3c.dom.Document;

public abstract class AXmlTransformationPipelet
extends ATransformationPipelet {
    protected Document createDocument(Blackboard blackboard, Id id) throws Exception {
        Document inputDocument = null;
        if (this.isReadFromAttribute()) {
            String value;
            Literal literal = blackboard.getLiteral(id, this._inputPath);
            if (literal != null && (value = literal.getStringValue()) != null) {
                inputDocument = XMLUtils.parse(value.getBytes("utf-8"), false);
            }
        } else {
            byte[] value = blackboard.getAttachment(id, this._inputName);
            inputDocument = XMLUtils.parse(value, false);
        }
        return inputDocument;
    }

    protected void storeDocument(Blackboard blackboard, Id id, Document doc) throws Exception {
        if (this.isStoreInAttribute()) {
            Literal literal = RecordFactory.DEFAULT_INSTANCE.createLiteral();
            literal.setStringValue(XMLUtils.documentToString(doc));
            blackboard.setLiteral(id, this._outputPath, literal);
        } else {
            byte[] attachment = XMLUtils.documentToBytes(doc);
            blackboard.setAttachment(id, this._outputName, attachment);
        }
    }
}

