/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.ConnectivityManager;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Annotation;
import org.eclipse.smila.datamodel.record.Attribute;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.pipelets.ATransformationPipelet;
import org.eclipse.smila.utils.service.ServiceUtils;
import org.eclipse.smila.utils.xml.stax.MarkerTag;
import org.eclipse.smila.utils.xml.stax.SimpleTagExtractor;
import org.eclipse.smila.utils.xml.stax.XmlSnippetHandler;
import org.eclipse.smila.utils.xml.stax.XmlSnippetSplitter;

public class XmlSplitterPipelet
extends ATransformationPipelet {
    public static final String PROP_BEGIN_TAG_NAME = "beginTagName";
    public static final String PROP_IS_BEGIN_CLOSING_TAG = "isBeginClosingTag";
    public static final String PROP_END_TAG_NAME = "endTagName";
    public static final String PROP_IS_END_CLOSING_TAG = "isEndClosingTag";
    public static final String PROP_KEY_TAG_NAME = "keyTagName";
    public static final String PROP_MAX_BUFFER_SIZE = "maxBufferSize";
    public static final int DEFAULT_MAX_BUFFER_SIZE = 20;
    private MarkerTag _beginTag;
    private MarkerTag _endTag;
    private String _keyTagName;
    private SimpleTagExtractor _extractor = new SimpleTagExtractor(true);
    private ConnectivityManager _connectivityManager;
    private ArrayList<Record> _recordBuffer = new ArrayList();
    private int _maxBufferSize = 20;

    public void configure(PipeletConfiguration configuration) throws ProcessingException {
        super.configure(configuration);
        String beginTagName = (String)configuration.getPropertyFirstValueNotNull(PROP_BEGIN_TAG_NAME);
        if (beginTagName.trim().length() == 0) {
            throw new ProcessingException("Property beginTagName must not be an empty String");
        }
        boolean isBeginEndTag = Boolean.valueOf((String)configuration.getPropertyFirstValueNotNull(PROP_IS_BEGIN_CLOSING_TAG));
        String endTagName = (String)configuration.getPropertyFirstValueNotNull(PROP_END_TAG_NAME);
        if (endTagName.trim().length() == 0) {
            throw new ProcessingException("Property endTagName must not be an empty String");
        }
        boolean isEndEndTag = Boolean.valueOf((String)configuration.getPropertyFirstValueNotNull(PROP_IS_END_CLOSING_TAG));
        this._keyTagName = (String)configuration.getPropertyFirstValueNotNull(PROP_KEY_TAG_NAME);
        if (this._keyTagName.trim().length() == 0) {
            throw new ProcessingException("Property keyTagName must not be an empty String");
        }
        String bufferSize = (String)configuration.getPropertyFirstValue(PROP_MAX_BUFFER_SIZE);
        if (bufferSize != null) {
            this._maxBufferSize = Integer.parseInt(bufferSize);
        }
        this._beginTag = new MarkerTag(beginTagName, isBeginEndTag);
        this._endTag = new MarkerTag(endTagName, isEndEndTag);
    }

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        InternalHandler snippetHandler = new InternalHandler();
        XmlSnippetSplitter splitter = new XmlSnippetSplitter((XmlSnippetHandler)snippetHandler, this._beginTag, this._endTag);
        if (recordIds != null) {
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    Id id = idArray[n2];
                    try {
                        InputStream inputStream = null;
                        inputStream = this.isReadFromAttribute() ? this.loadExternalInputStream(this.readStringInput(blackboard, id)) : blackboard.getAttachmentAsStream(id, this.getInputName());
                        snippetHandler.setCurrentId(id);
                        splitter.read(inputStream);
                        if (this._log.isInfoEnabled()) {
                            this._log.info((Object)("Created " + snippetHandler.getRecordCount() + " records from processing record " + id));
                        }
                    }
                    catch (Exception e) {
                        if (!this._log.isWarnEnabled()) break block7;
                        this._log.warn((Object)("unable to split record " + id), (Throwable)e);
                    }
                }
                ++n2;
            }
            try {
                this.flushRecordBuffer();
            }
            catch (Exception e) {
                throw new ProcessingException("error flushing record buffer", (Throwable)e);
            }
        }
        return recordIds;
    }

    private ConnectivityManager getConnectivityManager() throws InterruptedException {
        if (this._connectivityManager == null) {
            this._connectivityManager = (ConnectivityManager)ServiceUtils.getService(ConnectivityManager.class);
        }
        return this._connectivityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToRecordBuffer(Record record) throws ConnectivityException, InterruptedException {
        ArrayList<Record> arrayList = this._recordBuffer;
        synchronized (arrayList) {
            this._recordBuffer.add(record);
            if (this._recordBuffer.size() >= this._maxBufferSize) {
                this.flushRecordBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushRecordBuffer() throws ConnectivityException, InterruptedException {
        ArrayList<Record> arrayList = this._recordBuffer;
        synchronized (arrayList) {
            if (!this._recordBuffer.isEmpty()) {
                try {
                    this.getConnectivityManager().add(this._recordBuffer.toArray(new Record[this._recordBuffer.size()]));
                }
                finally {
                    this._recordBuffer.clear();
                }
            }
        }
    }

    private InputStream loadExternalInputStream(String attrtibuteValue) throws IOException {
        InputStream stream = null;
        if (attrtibuteValue != null && attrtibuteValue.trim().length() > 0) {
            if (attrtibuteValue.startsWith("file")) {
                URL url = new URL(attrtibuteValue);
                stream = new FileInputStream(String.valueOf(url.getAuthority()) + url.getPath());
            } else if (attrtibuteValue.startsWith("http")) {
                URL url = new URL(attrtibuteValue);
                HttpClient httpClient = new HttpClient();
                GetMethod getMethod = new GetMethod(url.toString());
                httpClient.executeMethod((HttpMethod)getMethod);
                stream = getMethod.getResponseBodyAsStream();
            } else {
                stream = new FileInputStream(attrtibuteValue);
            }
        }
        return stream;
    }

    class InternalHandler
    implements XmlSnippetHandler {
        private Id _currentId;
        private int _recordCounter;
        private int _countById;

        InternalHandler() {
        }

        void setCurrentId(Id id) {
            this._currentId = id;
            this._countById = 0;
        }

        int getRecordCount() {
            return this._recordCounter;
        }

        public void handleSnippet(byte[] snippet) {
            block9: {
                ++this._countById;
                Id snippetId = null;
                try {
                    List keys = XmlSplitterPipelet.this._extractor.getTags(XmlSplitterPipelet.this._keyTagName, (InputStream)new ByteArrayInputStream(snippet));
                    if (!keys.isEmpty()) {
                        snippetId = this._currentId.createFragmentId((String)keys.get(0));
                        Record record = RecordFactory.DEFAULT_INSTANCE.createRecord();
                        record.setId(snippetId);
                        if (XmlSplitterPipelet.this.isStoreInAttribute()) {
                            Literal literal = RecordFactory.DEFAULT_INSTANCE.createLiteral();
                            literal.setStringValue(new String(snippet, "utf-8"));
                            Attribute attribute = RecordFactory.DEFAULT_INSTANCE.createAttribute();
                            attribute.addLiteral(literal);
                            record.getMetadata().setAttribute(XmlSplitterPipelet.this._outputName, attribute);
                        } else {
                            record.setAttachment(XmlSplitterPipelet.this._outputName, snippet);
                        }
                        Annotation messageProperties = RecordFactory.DEFAULT_INSTANCE.createAnnotation();
                        messageProperties.setNamedValue("isXmlSnippet", Boolean.toString(true));
                        record.getMetadata().addAnnotation("MessageProperties", messageProperties);
                        ++this._recordCounter;
                        XmlSplitterPipelet.this.addToRecordBuffer(record);
                    } else {
                        if (XmlSplitterPipelet.this._log.isWarnEnabled()) {
                            XmlSplitterPipelet.this._log.warn((Object)("could not find tag " + XmlSplitterPipelet.this._keyTagName + " in snippet number " + this._countById + " of record " + this._currentId));
                        }
                        if (XmlSplitterPipelet.this._log.isTraceEnabled()) {
                            XmlSplitterPipelet.this._log.trace((Object)("snippet content: " + new String(snippet)));
                        }
                    }
                }
                catch (Exception e) {
                    if (XmlSplitterPipelet.this._log.isErrorEnabled()) {
                        XmlSplitterPipelet.this._log.error((Object)("error creating record for xml snippet number " + this._countById + " with id " + snippetId + " of record " + this._currentId), (Throwable)e);
                    }
                    if (!XmlSplitterPipelet.this._log.isTraceEnabled()) break block9;
                    XmlSplitterPipelet.this._log.trace((Object)("snippet content: " + new String(snippet)));
                }
            }
        }
    }
}

