/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.DOMErrorHandler;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XMLUtilsConfig;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XMLUtilsException;
import org.eclipse.smila.processing.pipelets.xmlprocessing.util.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLUtils {
    private static SymbolTable s_symbolTable;
    private static XMLGrammarPoolImpl s_grammarPool;
    private static String s_hexServerIP;
    private static final SecureRandom SEEDER;
    private static final int BIG_PRIME = 2039;
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static TransformerFactory s_transformerFactory;
    private static DocumentBuilderFactory s_builderFactory;

    static {
        SEEDER = new SecureRandom();
        s_transformerFactory = TransformerFactory.newInstance();
        s_builderFactory = DocumentBuilderFactory.newInstance();
    }

    private XMLUtils() {
    }

    public static Document newDocument() throws XmlException {
        try {
            DocumentBuilder documentBuilder = s_builderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new XmlException(e);
        }
    }

    public static String documentToString(Document document) throws XmlException {
        if (document == null) {
            return null;
        }
        try {
            Transformer transformer = s_transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            return ((Object)writer).toString();
        }
        catch (TransformerConfigurationException e) {
            throw new XmlException(e);
        }
        catch (TransformerException e) {
            throw new XmlException(e);
        }
    }

    private static synchronized DOMParser getParser(XMLUtilsConfig cfg) throws XMLUtilsException {
        DOMParser parser = new DOMParser();
        if (!(cfg.getIncludeIgnorabelWhitespace() == null || cfg.getIncludeIgnorabelWhitespace().booleanValue() || cfg.getValidate() != null && cfg.getValidate().booleanValue())) {
            throw new XMLUtilsException("When setting ignorableWhitespace, validate must be true too! To remove all TextNodes containg only WS use method XMLUtils.removeWhitespaceTextNodes(Element)");
        }
        try {
            if (s_symbolTable != null) {
                parser.setProperty(SYMBOL_TABLE, (Object)s_symbolTable);
            }
            if (s_grammarPool != null) {
                parser.setProperty(GRAMMAR_POOL, (Object)s_grammarPool);
            }
            Iterator<String> iter = cfg.getFeatures();
            while (iter.hasNext()) {
                String feat = iter.next();
                parser.setFeature(feat, cfg.getFeatureValue(feat));
            }
        }
        catch (SAXException e) {
            throw new XMLUtilsException("Error while setting feature!", e);
        }
        parser.setErrorHandler((ErrorHandler)new DOMErrorHandler());
        return parser;
    }

    public static Document getDocument() {
        return new DocumentImpl();
    }

    public static Document getDocument(String docElement) {
        DocumentImpl doc = new DocumentImpl();
        Element el = doc.createElement(docElement);
        doc.appendChild(el);
        return doc;
    }

    public static Document parse(byte[] bytes, boolean validate) throws XMLUtilsException {
        return XMLUtils.parse(new InputSource(new ByteArrayInputStream(bytes)), new XMLUtilsConfig(validate, true));
    }

    public static Document parse(byte[] bytes, XMLUtilsConfig cfg) throws XMLUtilsException {
        return XMLUtils.parse(new InputSource(new ByteArrayInputStream(bytes)), cfg);
    }

    public static Document parse(File file, boolean validate) throws XMLUtilsException {
        return XMLUtils.parse(file, new XMLUtilsConfig(validate, true));
    }

    public static Document parse(File file, XMLUtilsConfig cfg) throws XMLUtilsException {
        try {
            return XMLUtils.parse(new InputSource(new FileInputStream(file)), cfg);
        }
        catch (Throwable e) {
            throw new XMLUtilsException("File " + file.getAbsolutePath() + " not found.", e);
        }
    }

    public static Document parse(InputStream is, boolean validate) throws XMLUtilsException {
        return XMLUtils.parse(is, new XMLUtilsConfig(validate, true));
    }

    public static Document parse(InputStream is, XMLUtilsConfig cfg) throws XMLUtilsException {
        return XMLUtils.parse(new InputSource(is), cfg);
    }

    private static Document parse(InputSource inputSource, XMLUtilsConfig cfg) throws XMLUtilsException {
        DOMParser parser = XMLUtils.getParser(cfg);
        try {
            parser.parse(inputSource);
            return parser.getDocument();
        }
        catch (Exception e) {
            throw new XMLUtilsException("Error while parsing XML document!", e);
        }
    }

    public static byte[] stream(Element el, boolean validate) throws XMLUtilsException {
        return XMLUtils.stream(el, validate, "UTF-8", false);
    }

    public static byte[] stream(Element el, boolean validate, boolean preserveSpace) throws XMLUtilsException {
        return XMLUtils.stream(el, validate, "UTF-8", preserveSpace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] stream(Element el, boolean validate, String enc, boolean preserveSpace) throws XMLUtilsException {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] xml = null;
        try {
            OutputFormat of = new OutputFormat("XML", enc, true);
            of.setIndent(2);
            of.setLineWidth(0);
            if (preserveSpace) {
                of.setPreserveSpace(preserveSpace);
            }
            XMLSerializer xs = new XMLSerializer((OutputStream)baos, of);
            xs.setNamespaces(true);
            xs.serialize(el);
            xml = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException("Failed to stream due to: ", e);
        }
        try {
            if (validate) {
                XMLUtils.parse(xml, validate);
            }
            byArray = xml;
        }
        catch (XMLUtilsException e) {
            try {
                throw new XMLUtilsException("The given xml document is not valid!", e);
            }
            catch (Throwable throwable) {
                try {
                    if (baos == null) throw throwable;
                    baos.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (baos == null) return byArray;
            baos.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
    }

    public static void stream(Element el, boolean validate, String enc, File file) throws XMLUtilsException {
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                XMLUtils.stream(el, validate, enc, fos);
                fos.close();
            }
            catch (FileNotFoundException e) {
                throw new XMLUtilsException("File not found.", e);
            }
            catch (IOException e) {
                throw new XMLUtilsException("Other file-access exception", e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static void stream(Element el, boolean validate, String enc, OutputStream os) throws XMLUtilsException {
        if (validate) {
            XMLUtils.validate(el);
        }
        try {
            OutputFormat of = new OutputFormat("XML", enc, true);
            of.setIndent(2);
            of.setLineWidth(0);
            XMLSerializer xs = new XMLSerializer(os, of);
            xs.setNamespaces(true);
            xs.serialize(el);
        }
        catch (Exception e) {
            throw new XMLUtilsException("Failed to stream due to: ", e);
        }
    }

    public static boolean validate(Element el) throws XMLUtilsException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] xml = null;
        try {
            try {
                OutputFormat of = new OutputFormat("XML", "UTF-8", false);
                of.setIndent(0);
                of.setLineWidth(0);
                XMLSerializer xs = new XMLSerializer((OutputStream)baos, of);
                xs.setNamespaces(true);
                xs.serialize(el);
                xml = baos.toByteArray();
                baos.close();
            }
            catch (Exception e) {
                throw new XMLUtilsException("Failed to stream due to: ", e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (baos != null) {
                baos.close();
            }
        }
        catch (IOException iOException) {}
        try {
            XMLUtils.parse(xml, true);
            return true;
        }
        catch (XMLUtilsException e) {
            throw new XMLUtilsException("The given XML document is not valid!", e);
        }
    }

    public static void removeWhitespaceTextNodes(Element parent) {
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node child = nl.item(i);
            if (child.getNodeType() == 3) {
                if (child.getNodeValue().trim().length() == 0) {
                    parent.removeChild(child);
                    --i;
                }
            } else if (child.getNodeType() == 1 && child.getChildNodes().getLength() > 0) {
                XMLUtils.removeWhitespaceTextNodes((Element)child);
            }
            ++i;
        }
    }

    public static Date decodeDate(String xmlDate) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat();
        df.applyPattern("yyyy-MM-dd");
        return df.parse(xmlDate);
    }

    public static String encodeDate(Date javaDate) {
        SimpleDateFormat df = new SimpleDateFormat();
        df.applyPattern("yyyy-MM-dd");
        return df.format(javaDate);
    }

    public static Date decodeDateTime(String xmlDate) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat();
        df.applyPattern("yyyy-MM-dd'T'hh:mm:ss");
        return df.parse(xmlDate);
    }

    public static String encodeDateTime(Date javaDate) {
        SimpleDateFormat df = new SimpleDateFormat();
        df.applyPattern("yyyy-MM-dd'T'hh:mm:ss");
        return df.format(javaDate);
    }

    public static boolean decodeBoolean(String xmlBoolean) {
        return "true".equals(xmlBoolean) || "yes".equals(xmlBoolean) || "on".equals(xmlBoolean) || "1".equals(xmlBoolean);
    }

    public static String encodeBoolean(boolean javaBoolean) {
        if (javaBoolean) {
            return "true";
        }
        return "false";
    }

    public static int decodeInteger(String xmlInteger) {
        return new Integer(xmlInteger);
    }

    public static String encodeInteger(int value) {
        return String.valueOf(value);
    }

    public static String encodeInteger(Integer value) {
        return String.valueOf(value);
    }

    public static String getLocalPart(String xml) {
        int pos = xml.indexOf(":");
        if (pos >= 0) {
            xml = xml.substring(pos + 1);
        }
        return xml;
    }

    public static boolean isXML(File file) {
        boolean retval = false;
        try {
            XMLUtils.parse(file, false);
            retval = true;
        }
        catch (XMLUtilsException xMLUtilsException) {}
        return retval;
    }

    public static boolean isXML(byte[] message) {
        boolean retval = false;
        try {
            XMLUtils.parse(message, false);
            retval = true;
        }
        catch (XMLUtilsException xMLUtilsException) {}
        return retval;
    }

    public static boolean isXML(InputStream is) {
        boolean retval = false;
        try {
            XMLUtils.parse(is, false);
            retval = true;
        }
        catch (XMLUtilsException xMLUtilsException) {}
        return retval;
    }

    public static synchronized void loadSchemas(File folder, final String filter, String schemaUrlPrefix) throws XMLUtilsException {
        try {
            File[] schemas = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(filter);
                }
            });
            int i = 0;
            while (i < schemas.length) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(schemas[i]);
                    XMLUtils.loadSchema(String.valueOf(schemaUrlPrefix) + schemas[i].getName(), fis);
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new XMLUtilsException("unable to cache schemas", e);
        }
    }

    public static synchronized void loadSchema(String schemaName, InputStream schema) throws XMLUtilsException {
        if (s_symbolTable == null) {
            s_symbolTable = new SymbolTable(2039);
            s_grammarPool = new XMLGrammarPoolImpl();
        }
        XMLGrammarPreparser preparser = new XMLGrammarPreparser(s_symbolTable);
        preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
        preparser.setProperty(GRAMMAR_POOL, (Object)s_grammarPool);
        try {
            Grammar g = preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", new XMLInputSource(null, schemaName, null, schema, null));
        }
        catch (IOException e) {
            throw new XMLUtilsException("unable to cache schema [" + schemaName + "]", e);
        }
    }

    public static synchronized void clearGrammarCache() {
        s_symbolTable = null;
        s_grammarPool = null;
    }

    public static synchronized void setGrammarCacheLock(boolean lockState) {
        if (s_grammarPool != null) {
            if (lockState) {
                s_grammarPool.lockPool();
            } else {
                s_grammarPool.unlockPool();
            }
        }
    }

    public static final String generateGUID(Object o) {
        Log log = LogFactory.getLog(XMLUtils.class);
        StringBuffer tmpBuffer = new StringBuffer(16);
        if (s_hexServerIP == null) {
            InetAddress localInetAddress = null;
            try {
                localInetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                System.err.println("ConfigurationUtil: Could not get the local IP address using InetAddress.getLocalHost()!");
                if (log.isErrorEnabled()) {
                    log.error((Object)uhe);
                }
                return null;
            }
            byte[] serverIP = localInetAddress.getAddress();
            s_hexServerIP = XMLUtils.hexFormat(XMLUtils.getInt(serverIP), 8);
        }
        String hashcode = XMLUtils.hexFormat(System.identityHashCode(o), 8);
        tmpBuffer.append(s_hexServerIP);
        tmpBuffer.append(hashcode);
        long timeNow = System.currentTimeMillis();
        int timeLow = (int)timeNow & 0xFFFFFFFF;
        int node = SEEDER.nextInt();
        StringBuffer guid = new StringBuffer(32);
        guid.append(XMLUtils.hexFormat(timeLow, 8));
        guid.append(tmpBuffer.toString());
        guid.append(XMLUtils.hexFormat(node, 8));
        return guid.toString();
    }

    private static int getInt(byte[] bytes) {
        int i = 0;
        int j = 24;
        int k = 0;
        while (j >= 0) {
            int l = bytes[k] & 0xFF;
            i += l << j;
            j -= 8;
            ++k;
        }
        return i;
    }

    private static String hexFormat(int i, int j) {
        String s = Integer.toHexString(i);
        return String.valueOf(XMLUtils.padHex(s, j)) + s;
    }

    private static String padHex(String s, int i) {
        StringBuffer tmpBuffer = new StringBuffer();
        if (s.length() < i) {
            int j = 0;
            while (j < i - s.length()) {
                tmpBuffer.append('0');
                ++j;
            }
        }
        return tmpBuffer.toString();
    }

    public static byte[] documentToBytes(Document document) throws XmlException {
        if (document == null) {
            return null;
        }
        try {
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            Transformer transformer = s_transformerFactory.newTransformer();
            transformer.transform(source, result);
            return out.toByteArray();
        }
        catch (TransformerConfigurationException e) {
            throw new XmlException(e);
        }
        catch (TransformerException e) {
            throw new XmlException(e);
        }
    }
}

