/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.Coefficient;
import org.eclipse.smila.management.ManagementAgent;
import org.eclipse.smila.management.error.ErrorsBuffer;
import org.eclipse.smila.management.jmx.ClassHelper;
import org.eclipse.smila.management.performance.PerformanceCounter;

public class AgentMBean
implements DynamicMBean {
    private final Log _log = LogFactory.getLog(AgentMBean.class);
    private final ModelMBeanInfo _beanInfo;
    private final ManagementAgent _agent;

    public AgentMBean(ModelMBeanInfo beanInfo, ManagementAgent agent) {
        this._beanInfo = beanInfo;
        this._agent = agent;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return (MBeanInfo)this._beanInfo.clone();
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ModelMBeanAttributeInfo info = this._beanInfo.getAttribute(attribute);
        Descriptor descriptor = info.getDescriptor();
        String getterMethod = (String)descriptor.getFieldValue("getMethod");
        return this.invoke(getterMethod, ClassHelper.EMPTY_PARAMS, ClassHelper.EMPTY_SIGNATURE);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object result;
        Method method;
        Class[] classesSig = new Class[signature.length];
        int i = 0;
        while (i < signature.length) {
            classesSig[i] = ClassHelper.searchClass(signature[i]);
            ++i;
        }
        try {
            method = this._agent.getClass().getMethod(actionName, classesSig);
        }
        catch (Exception e) {
            this._log.error((Object)e);
            throw new ReflectionException(e);
        }
        try {
            result = method.invoke((Object)this._agent, params);
        }
        catch (Exception e) {
            this._log.error((Object)e);
            throw new ReflectionException(e);
        }
        return this.processValue(result, method);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        ModelMBeanAttributeInfo info = this._beanInfo.getAttribute(attribute.getName());
        if (info == null) {
            String msg = "MBean " + this._beanInfo.getClassName() + " doesnt contain attribute Information for method " + attribute.getName() + ", please check if you have defined a gettter and setter for this Attriubute!";
            this._log.error((Object)msg);
            throw new AttributeNotFoundException(msg);
        }
        Descriptor descriptor = info.getDescriptor();
        String setterMethod = (String)descriptor.getFieldValue("setMethod");
        String setterSignatureClass = (String)descriptor.getFieldValue("setterSignatureClass");
        this.invoke(setterMethod, new Object[]{attribute.getValue()}, new String[]{setterSignatureClass});
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames must not be null"), "Exception occured trying to get attributes of a LocalMBean");
        }
        AttributeList attributeList = new AttributeList();
        int i = 0;
        while (i < attributes.length) {
            String attributeName = attributes[i];
            try {
                attributeList.add(new Attribute(attributeName, this.getAttribute(attributeName)));
            }
            catch (Throwable e) {
                this._log.error((Object)("getAttributes(String[]), failed to get \"" + attributeName + "\""), e);
            }
            ++i;
        }
        return attributeList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributes must not be null"), "Exception occured trying to set attributes of a LocalMBean");
        }
        AttributeList attributeList = new AttributeList();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            try {
                this.setAttribute(attribute);
                attributeList.add(attribute);
            }
            catch (Exception exception) {
                i.remove();
            }
        }
        return attributeList;
    }

    private Object processValue(Object result, Method method) {
        if (result == null) {
            return null;
        }
        if (PerformanceCounter.class.isAssignableFrom(result.getClass())) {
            PerformanceCounter counter = (PerformanceCounter)result;
            double value = counter.getNextSampleValue();
            if (method.isAnnotationPresent(Coefficient.class)) {
                Coefficient coefficient = method.getAnnotation(Coefficient.class);
                double coefficientToApply = coefficient.value();
                value *= coefficientToApply;
            }
            return value;
        }
        if (ErrorsBuffer.class.isAssignableFrom(result.getClass())) {
            ErrorsBuffer buffer = (ErrorsBuffer)result;
            return buffer.getErrors();
        }
        return result;
    }
}

