/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.file.FileComponent;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.component.file.FileProcessStrategy;
import org.apache.camel.component.file.FileProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.util.FactoryFinder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UuidGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEndpoint
extends ScheduledPollEndpoint<FileExchange> {
    private static final transient Log LOG = LogFactory.getLog(FileEndpoint.class);
    private static final String DEFAULT_STRATEGYFACTORY_CLASS = "org.apache.camel.component.file.strategy.FileProcessStrategyFactory";
    private File file;
    private FileProcessStrategy fileProcessStrategy;
    private boolean autoCreate = true;
    private boolean lock = true;
    private boolean delete;
    private boolean noop;
    private boolean append = true;
    private String moveNamePrefix;
    private String moveNamePostfix;
    private String[] excludedNamePrefixes = new String[]{"."};
    private String[] excludedNamePostfixes = new String[]{".cameLock"};
    private int bufferSize = 131072;
    private boolean ignoreFileNameHeader;

    protected FileEndpoint(File file, String endpointUri, FileComponent component) {
        super(endpointUri, component);
        this.file = file;
    }

    public FileEndpoint(String endpointUri, File file) {
        super(endpointUri);
        this.file = file;
    }

    public FileEndpoint(File file) {
        this.file = file;
    }

    public FileEndpoint() {
    }

    @Override
    public Producer<FileExchange> createProducer() throws Exception {
        FileProducer result = new FileProducer(this);
        return result;
    }

    @Override
    public Consumer<FileExchange> createConsumer(Processor processor) throws Exception {
        FileConsumer result = new FileConsumer(this, processor);
        this.configureConsumer(result);
        return result;
    }

    public FileExchange createExchange(File file) {
        return new FileExchange(this.getCamelContext(), this.getExchangePattern(), file);
    }

    @Override
    public FileExchange createExchange() {
        return this.createExchange(this.getFile());
    }

    @Override
    public FileExchange createExchange(ExchangePattern pattern) {
        return new FileExchange(this.getCamelContext(), pattern, this.file);
    }

    public String getGeneratedFileName(Message message) {
        return this.getFileFriendlyMessageId(message.getMessageId());
    }

    public void configureMessage(File file, Message message) {
        message.setBody(file);
        String relativePath = file.getPath().substring(this.getFile().getPath().length());
        if (relativePath.startsWith(File.separator) || relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        message.setHeader("org.apache.camel.file.name", relativePath);
    }

    public File getFile() {
        ObjectHelper.notNull(this.file, "file");
        if (this.autoCreate && !this.file.exists()) {
            this.file.mkdirs();
        }
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public boolean isAutoCreate() {
        return this.autoCreate;
    }

    public void setAutoCreate(boolean autoCreate) {
        this.autoCreate = autoCreate;
    }

    public FileProcessStrategy getFileStrategy() {
        if (this.fileProcessStrategy == null) {
            this.fileProcessStrategy = this.createFileStrategy();
            LOG.debug((Object)("Using file process strategy: " + this.fileProcessStrategy));
        }
        return this.fileProcessStrategy;
    }

    public void setFileStrategy(FileProcessStrategy fileProcessStrategy) {
        this.fileProcessStrategy = fileProcessStrategy;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public String getMoveNamePostfix() {
        return this.moveNamePostfix;
    }

    public void setMoveNamePostfix(String moveNamePostfix) {
        this.moveNamePostfix = moveNamePostfix;
    }

    public String getMoveNamePrefix() {
        return this.moveNamePrefix;
    }

    public void setMoveNamePrefix(String moveNamePrefix) {
        this.moveNamePrefix = moveNamePrefix;
    }

    public String[] getExcludedNamePrefixes() {
        return this.excludedNamePrefixes;
    }

    public void setExcludedNamePrefixes(String[] excludedNamePrefixes) {
        this.excludedNamePrefixes = excludedNamePrefixes;
    }

    public String[] getExcludedNamePostfixes() {
        return this.excludedNamePostfixes;
    }

    public void setExcludedNamePostfixes(String[] excludedNamePostfixes) {
        this.excludedNamePostfixes = excludedNamePostfixes;
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isIgnoreFileNameHeader() {
        return this.ignoreFileNameHeader;
    }

    public void setIgnoreFileNameHeader(boolean ignoreFileNameHeader) {
        this.ignoreFileNameHeader = ignoreFileNameHeader;
    }

    protected FileProcessStrategy createFileStrategy() {
        Class<?> factory = null;
        try {
            FactoryFinder finder = new FactoryFinder("META-INF/services/org/apache/camel/component/");
            factory = finder.findClass("file", "strategy.factory.");
        }
        catch (ClassNotFoundException e) {
            LOG.debug((Object)"'strategy.factory.class' not found", (Throwable)e);
        }
        catch (IOException e) {
            LOG.debug((Object)"No strategy factory defined in 'META-INF/services/org/apache/camel/component/file'", (Throwable)e);
        }
        if (factory == null && (factory = ObjectHelper.loadClass(DEFAULT_STRATEGYFACTORY_CLASS)) == null) {
            throw new TypeNotPresentException("FileProcessStrategyFactory class not found", null);
        }
        try {
            Method factoryMethod = factory.getMethod("createFileProcessStrategy", Properties.class);
            return (FileProcessStrategy)ObjectHelper.invokeMethod(factoryMethod, null, this.getParamsAsProperties());
        }
        catch (NoSuchMethodException e) {
            throw new TypeNotPresentException(factory.getSimpleName() + ".createFileProcessStrategy(Properties params) method not found", e);
        }
    }

    protected Properties getParamsAsProperties() {
        Properties params = new Properties();
        if (this.isNoop()) {
            params.setProperty("noop", Boolean.toString(true));
        }
        if (this.isDelete()) {
            params.setProperty("delete", Boolean.toString(true));
        }
        if (this.isAppend()) {
            params.setProperty("append", Boolean.toString(true));
        }
        if (this.isLock()) {
            params.setProperty("lock", Boolean.toString(true));
        }
        if (this.moveNamePrefix != null) {
            params.setProperty("moveNamePrefix", this.moveNamePrefix);
        }
        if (this.moveNamePostfix != null) {
            params.setProperty("moveNamePostfix", this.moveNamePostfix);
        }
        return params;
    }

    @Override
    protected String createEndpointUri() {
        return "file://" + this.getFile().getAbsolutePath();
    }

    protected String getFileFriendlyMessageId(String id) {
        return UuidGenerator.generateSanitizedId(id);
    }
}

