/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EdirEventSpecifier;
import com.novell.ldap.rfc2251.RfcLDAPMessage;

public class MonitorEventResponse
extends LDAPExtendedResponse {
    private EdirEventSpecifier[] specifierlist = new EdirEventSpecifier[0];

    public MonitorEventResponse(RfcLDAPMessage rfcLDAPMessage) throws LDAPException {
        super(rfcLDAPMessage);
        byte[] byArray = this.getValue();
        if (byArray == null) {
            throw new LDAPException(LDAPException.resultCodeToString(this.getResultCode()), this.getResultCode(), null);
        }
        LBERDecoder lBERDecoder = new LBERDecoder();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
        int n = ((ASN1Integer)aSN1Sequence.get(0)).intValue();
        ASN1Set aSN1Set = (ASN1Set)aSN1Sequence.get(1);
        this.specifierlist = new EdirEventSpecifier[n];
        for (int i = 0; i < n; ++i) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Set.get(i);
            int n2 = ((ASN1Integer)aSN1Sequence2.get(0)).intValue();
            int n3 = ((ASN1Enumerated)aSN1Sequence2.get(1)).intValue();
            this.specifierlist[i] = new EdirEventSpecifier(n2, n3);
        }
    }

    public EdirEventSpecifier[] getSpecifierList() {
        return this.specifierlist;
    }
}

