/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class GeneralDSEventData
implements EventResponseData {
    private static final int EVT_TAG_GEN_DSTIME = 1;
    private static final int EVT_TAG_GEN_MILLISEC = 2;
    private static final int EVT_TAG_GEN_VERB = 3;
    private static final int EVT_TAG_GEN_CURRPROC = 4;
    private static final int EVT_TAG_GEN_PERP = 5;
    private static final int EVT_TAG_GEN_INTEGERS = 6;
    private static final int EVT_TAG_GEN_STRINGS = 7;
    private final int dsTime;
    private final int milliseconds;
    private final int verb;
    private final int currentProcess;
    private final String perpetratorDN;
    private final int[] integerValues;
    private final String[] stringValues;

    public GeneralDSEventData(ASN1Object aSN1Object) throws IOException {
        int n;
        ASN1Object[] aSN1ObjectArray;
        ASN1Sequence aSN1Sequence;
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int[] nArray = new int[1];
        this.dsTime = this.getTaggedintValue((ASN1Tagged)lBERDecoder.decode(byteArrayInputStream, nArray), 1);
        this.milliseconds = this.getTaggedintValue((ASN1Tagged)lBERDecoder.decode(byteArrayInputStream, nArray), 2);
        this.verb = this.getTaggedintValue((ASN1Tagged)lBERDecoder.decode(byteArrayInputStream, nArray), 3);
        this.currentProcess = this.getTaggedintValue((ASN1Tagged)lBERDecoder.decode(byteArrayInputStream, nArray), 4);
        this.perpetratorDN = this.getTaggedStringValue((ASN1Tagged)lBERDecoder.decode(byteArrayInputStream, nArray), 5);
        ASN1Tagged aSN1Tagged = (ASN1Tagged)lBERDecoder.decode(byteArrayInputStream, nArray);
        if (aSN1Tagged.getIdentifier().getTag() == 6) {
            aSN1Sequence = this.getTaggedSequence(aSN1Tagged, 6);
            aSN1ObjectArray = aSN1Sequence.toArray();
            this.integerValues = new int[aSN1ObjectArray.length];
            for (n = 0; n < aSN1ObjectArray.length; ++n) {
                this.integerValues[n] = ((ASN1Integer)aSN1ObjectArray[n]).intValue();
            }
            aSN1Tagged = (ASN1Tagged)lBERDecoder.decode(byteArrayInputStream, nArray);
        } else {
            this.integerValues = null;
        }
        if (aSN1Tagged.getIdentifier().getTag() == 7 && aSN1Tagged.getIdentifier().getConstructed()) {
            aSN1Sequence = this.getTaggedSequence(aSN1Tagged, 7);
            aSN1ObjectArray = aSN1Sequence.toArray();
            this.stringValues = new String[aSN1ObjectArray.length];
            for (n = 0; n < aSN1ObjectArray.length; ++n) {
                this.stringValues[n] = ((ASN1OctetString)aSN1ObjectArray[n]).stringValue();
            }
        } else {
            this.stringValues = null;
        }
    }

    public int getCurrentProcess() {
        return this.currentProcess;
    }

    public int getDsTime() {
        return this.dsTime;
    }

    public int[] getIntegerValues() {
        return this.integerValues;
    }

    public int getMilliSeconds() {
        return this.milliseconds;
    }

    public String getPerpetratorDN() {
        return this.perpetratorDN;
    }

    public String[] getStringValues() {
        return this.stringValues;
    }

    public int getVerb() {
        return this.verb;
    }

    private int getTaggedintValue(ASN1Tagged aSN1Tagged, int n) throws IOException {
        ASN1Object aSN1Object = aSN1Tagged.taggedValue();
        if (n != aSN1Tagged.getIdentifier().getTag()) {
            throw new IOException("Unknown Tagged Data");
        }
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int n2 = byArray.length;
        return ((Long)lBERDecoder.decodeNumeric(byteArrayInputStream, n2)).intValue();
    }

    private String getTaggedStringValue(ASN1Tagged aSN1Tagged, int n) throws IOException {
        ASN1Object aSN1Object = aSN1Tagged.taggedValue();
        if (n != aSN1Tagged.getIdentifier().getTag()) {
            throw new IOException("Unknown Tagged Data");
        }
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int n2 = byArray.length;
        return (String)lBERDecoder.decodeCharacterString(byteArrayInputStream, n2);
    }

    private ASN1Sequence getTaggedSequence(ASN1Tagged aSN1Tagged, int n) throws IOException {
        ASN1Object aSN1Object = aSN1Tagged.taggedValue();
        if (n != aSN1Tagged.getIdentifier().getTag()) {
            throw new IOException("Unknown Tagged Data");
        }
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int n2 = byArray.length;
        return new ASN1Sequence(lBERDecoder, byteArrayInputStream, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[GeneralDSEventData");
        stringBuffer.append("(DSTime =" + this.getDsTime() + ")");
        stringBuffer.append("(MilliSeconds=" + this.getMilliSeconds() + ")");
        stringBuffer.append("(verb =" + this.getVerb() + ")");
        stringBuffer.append("(currentProcess " + this.getCurrentProcess() + ")");
        stringBuffer.append("(PerpetartorDN =" + this.getPerpetratorDN() + ")");
        stringBuffer.append("(Integer Values =" + this.getIntegerValues() + ")");
        stringBuffer.append("(String Values =" + this.getStringValues() + ")");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

