/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.datamodel.record.RecordFactory;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.SimplePipelet;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.pipelets.SourceType;

public abstract class ATransformationPipelet
implements SimplePipelet {
    public static final String PROP_INPUT_TYPE = "inputType";
    public static final String PROP_OUTPUT_TYPE = "outputType";
    public static final String PROP_INPUT_NAME = "inputName";
    public static final String PROP_OUTPUT_NAME = "outputName";
    public static final String ENCODING_ATTACHMENT = "utf-8";
    protected final Log _log = LogFactory.getLog(ATransformationPipelet.class);
    protected SourceType _inputType;
    protected SourceType _outputType;
    protected String _inputName;
    protected String _outputName;
    protected Path _inputPath;
    protected Path _outputPath;

    public void configure(PipeletConfiguration configuration) throws ProcessingException {
        this._inputType = SourceType.valueOf((String)configuration.getPropertyFirstValueNotNull(PROP_INPUT_TYPE));
        this._outputType = SourceType.valueOf((String)configuration.getPropertyFirstValueNotNull(PROP_OUTPUT_TYPE));
        this._inputName = (String)configuration.getPropertyFirstValueNotNull(PROP_INPUT_NAME);
        this._outputName = (String)configuration.getPropertyFirstValueNotNull(PROP_OUTPUT_NAME);
        if (this.isReadFromAttribute()) {
            this._inputPath = new Path(this._inputName);
        }
        if (this.isStoreInAttribute()) {
            this._outputPath = new Path(this._outputName);
        }
    }

    public SourceType getInputType() {
        return this._inputType;
    }

    public String getInputName() {
        return this._inputName;
    }

    public Path getInputPath() {
        return this._inputPath;
    }

    public SourceType getOutputType() {
        return this._outputType;
    }

    public String getOutputName() {
        return this._outputName;
    }

    public Path getOutputPath() {
        return this._outputPath;
    }

    public boolean isReadFromAttribute() {
        return SourceType.ATTRIBUTE.equals((Object)this._inputType);
    }

    public boolean isStoreInAttribute() {
        return SourceType.ATTRIBUTE.equals((Object)this._outputType);
    }

    protected void storeResult(Blackboard blackboard, Id id, String result) throws ProcessingException {
        if (this.isStoreInAttribute()) {
            try {
                Literal literal = blackboard.createLiteral(id);
                literal.setStringValue(result);
                blackboard.addLiteral(id, this._outputPath, literal);
            }
            catch (Exception e) {
                throw new ProcessingException("Could not set attribute " + this._outputName + " of record " + id, (Throwable)e);
            }
        }
        try {
            InputStream stringStream = IOUtils.toInputStream((String)result, (String)ENCODING_ATTACHMENT);
            blackboard.setAttachmentFromStream(id, this._outputName, stringStream);
        }
        catch (Exception e) {
            throw new ProcessingException("Could not set attachment " + this._outputName + " of record " + id, (Throwable)e);
        }
    }

    protected void storeResults(Blackboard blackboard, Id id, Collection<String> results) throws ProcessingException {
        if (!results.isEmpty()) {
            if (this.isStoreInAttribute()) {
                try {
                    blackboard.removeLiterals(id, this._outputPath);
                }
                catch (BlackboardAccessException e) {
                    throw new ProcessingException("Could not clear attribute " + this._outputName + " of record " + id, (Throwable)e);
                }
                for (String result : results) {
                    this.storeResult(blackboard, id, result);
                }
            } else {
                this.storeResult(blackboard, id, results.iterator().next());
            }
        }
    }

    protected void storeResult(Blackboard blackboard, Id id, byte[] bytes) throws Exception {
        if (this.isStoreInAttribute()) {
            Literal literal = RecordFactory.DEFAULT_INSTANCE.createLiteral();
            literal.setStringValue(new String(bytes, ENCODING_ATTACHMENT));
            blackboard.setLiteral(id, this._outputPath, literal);
        } else {
            blackboard.setAttachment(id, this._outputName, bytes);
        }
    }

    protected byte[] readInput(Blackboard blackboard, Id id) throws BlackboardAccessException, UnsupportedEncodingException {
        byte[] bytes = null;
        if (this.isReadFromAttribute()) {
            String value;
            Literal literal = blackboard.getLiteral(id, this._inputPath);
            if (literal != null && (value = literal.getStringValue()) != null) {
                bytes = value.getBytes(ENCODING_ATTACHMENT);
            }
        } else if (blackboard.hasAttachment(id, this._inputName)) {
            bytes = blackboard.getAttachment(id, this._inputName);
        }
        return bytes;
    }

    protected String readStringInput(Blackboard blackboard, Id id) throws BlackboardAccessException, UnsupportedEncodingException {
        byte[] bytes;
        String string = null;
        if (this.isReadFromAttribute()) {
            Literal literal = blackboard.getLiteral(id, this._inputPath);
            if (literal != null) {
                string = literal.getStringValue();
            }
        } else if (blackboard.hasAttachment(id, this._inputName) && (bytes = blackboard.getAttachment(id, this._inputName)) != null && bytes.length > 0) {
            string = new String(bytes, ENCODING_ATTACHMENT);
        }
        return string;
    }
}

