/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.util.List;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.path.Path;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Literal;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.SimplePipelet;
import org.eclipse.smila.processing.configuration.PipeletConfiguration;
import org.eclipse.smila.processing.parameters.ParameterAccessor;

public class AddLiteralsPipelet
implements SimplePipelet {
    private static final String PARAM_ATTRIBUTE = "AddLiterals.attribute";
    private static final String PARAM_VALUES = "AddLiterals.values";
    private PipeletConfiguration _configuration;

    public Id[] process(Blackboard blackboard, Id[] recordIds) throws ProcessingException {
        try {
            ParameterAccessor parameters = new ParameterAccessor(blackboard).setPipeletConfiguration(this._configuration);
            Id[] idArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                Id id = idArray[n2];
                parameters.setCurrentRecord(id);
                String attributeName = parameters.getRequiredParameter(PARAM_ATTRIBUTE);
                Path path = new Path(attributeName);
                List values = parameters.getParameters(PARAM_VALUES);
                if (values != null) {
                    for (String value : values) {
                        Literal literal = blackboard.createLiteral(id);
                        literal.setStringValue(value);
                        blackboard.addLiteral(id, path, literal);
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            throw new ProcessingException((Throwable)ex);
        }
        return recordIds;
    }

    public void configure(PipeletConfiguration configuration) throws ProcessingException {
        this._configuration = configuration;
    }
}

