/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.recordstorage.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.MObject;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;

public class RecordDao
implements Serializable {
    public static final String NAMED_QUERY_FIND_BY_SOURCE = "RecordDao.findBySource";
    public static final String NAMED_QUERY_PARAM_SOURCE = "source";
    public static final String ENTITY_MEMBER_ATTRIBUTES = "_attributes";
    private static final long serialVersionUID = 6500268394234442139L;
    private String _idHash;
    private String _source;
    private byte[] _serializedRecord;

    protected RecordDao() {
    }

    public RecordDao(Record record) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("parameter record is null");
        }
        if (record.getId() == null) {
            throw new IllegalArgumentException("parameter record has not Id set");
        }
        ArrayList<String> attachmentNames = new ArrayList<String>();
        Iterator names = record.getAttachmentNames();
        while (names.hasNext()) {
            attachmentNames.add((String)names.next());
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
        objectStream.writeObject(record.getId());
        objectStream.writeObject(record.getMetadata());
        objectStream.writeObject(attachmentNames);
        objectStream.close();
        this._serializedRecord = byteStream.toByteArray();
        this._idHash = record.getId().getIdHash();
        this._source = record.getId().getSource();
    }

    public Record toRecord() throws IOException, ClassNotFoundException {
        ObjectInputStream objectStream = new ObjectInputStream(new ByteArrayInputStream(this._serializedRecord));
        Id id = (Id)objectStream.readObject();
        MObject metadata = (MObject)objectStream.readObject();
        List attachmentNames = (List)objectStream.readObject();
        Record record = RecordFactory.DEFAULT_INSTANCE.createRecord();
        record.setId(id);
        record.setMetadata(metadata);
        for (String name : attachmentNames) {
            record.setAttachment(name, null);
        }
        objectStream.close();
        return record;
    }
}

