/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.deltaindexing.jpa.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingException;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingManager;
import org.eclipse.smila.connectivity.deltaindexing.DeltaIndexingSessionException;
import org.eclipse.smila.connectivity.deltaindexing.jpa.impl.DataSourceDao;
import org.eclipse.smila.connectivity.deltaindexing.jpa.impl.DeltaIndexingDao;
import org.eclipse.smila.connectivity.deltaindexing.jpa.impl.IdIterator;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;
import org.osgi.service.component.ComponentContext;

public class DeltaIndexingManagerImpl
implements DeltaIndexingManager {
    public static final String PERSISTENCE_UNIT_NAME = "DeltaIndexing";
    public static final String CONFIGURATION_FILE = "persistence.properties";
    private static final String BUNDLE_NAME = "org.eclipse.smila.connectivity.deltaindexing.jpa.impl";
    private final Log _log = LogFactory.getLog(DeltaIndexingManagerImpl.class);
    private Properties _properties;
    private EntityManagerFactory _emf;
    private ReadWriteLock _lock = new ReentrantReadWriteLock(true);

    protected synchronized void activate(ComponentContext context) throws Exception {
        EntityManager em = null;
        try {
            try {
                this.readConfiguration();
                if (!this._properties.containsKey("eclipselink.logging.file")) {
                    File workingDir = WorkspaceHelper.createWorkingDir((String)BUNDLE_NAME);
                    File logfile = new File(workingDir, "jpa.log");
                    this._properties.put("eclipselink.logging.file", logfile.getAbsolutePath());
                }
                this._emf = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, (Map)this._properties);
                em = this._emf.createEntityManager();
            }
            catch (Exception e) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)("error activating " + this.getClass()), (Throwable)e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            this.closeEntityManager(em);
            throw throwable;
        }
        this.closeEntityManager(em);
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("Activating " + this.getClass()));
        }
    }

    protected synchronized void deactivate(ComponentContext context) throws Exception {
        this._lock.writeLock().lock();
        try {
            block8: {
                try {
                    if (this._emf != null) {
                        this._emf.close();
                    }
                }
                catch (Exception e) {
                    if (!this._log.isErrorEnabled()) break block8;
                    this._log.error((Object)("error deactivating " + this.getClass()), (Throwable)e);
                }
            }
            this._emf = null;
            if (this._properties != null) {
                this._properties.clear();
                this._properties = null;
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("Deactivating " + this.getClass()));
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public String init(String dataSourceID) throws DeltaIndexingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public boolean checkForUpdate(String sessionId, Id id, String hash) throws DeltaIndexingSessionException, DeltaIndexingException {
        if (id == null) {
            throw new DeltaIndexingException("parameter id is null");
        }
        if (hash == null) {
            throw new DeltaIndexingException("parameter hash is null");
        }
        this._lock.readLock().lock();
        try {
            this.assertSession(sessionId, id.getSource());
            EntityManager em = this.createEntityManager();
            try {
                DeltaIndexingDao dao = this.findDeltaIndexingDao(em, id);
                if (dao == null || !hash.equals(dao.getHash())) {
                    return true;
                }
                EntityTransaction transaction = em.getTransaction();
                try {
                    transaction.begin();
                    this.visitUnchangedDaos(em, dao);
                    transaction.commit();
                }
                catch (Exception e) {
                    if (transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw new DeltaIndexingException("error visiting id: " + id, (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new DeltaIndexingException("error checking for update for id: " + id, (Throwable)e);
            }
            finally {
                this.closeEntityManager(em);
            }
            return false;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public void visit(String sessionId, Id id, String hash, boolean isCompound) throws DeltaIndexingSessionException, DeltaIndexingException {
        if (id == null) {
            throw new DeltaIndexingException("parameter id is null");
        }
        if (hash == null) {
            throw new DeltaIndexingException("parameter hash is null");
        }
        this._lock.readLock().lock();
        try {
            this.assertSession(sessionId, id.getSource());
            EntityManager em = this.createEntityManager();
            try {
                try {
                    DeltaIndexingDao dao = this.findDeltaIndexingDao(em, id);
                    this.visitNewOrChangedDao(em, dao, id, hash, isCompound);
                }
                catch (DeltaIndexingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DeltaIndexingException("error visiting id: " + id, (Throwable)e);
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Iterator<Id> obsoleteIdIterator(String sessionId, String dataSourceID) throws DeltaIndexingSessionException, DeltaIndexingException {
        if (dataSourceID == null) {
            throw new DeltaIndexingException("parameter dataSourceID is null");
        }
        this._lock.readLock().lock();
        try {
            this.assertSession(sessionId, dataSourceID);
            EntityManager em = this.createEntityManager();
            try {
                Query query = em.createNamedQuery("DeltaIndexingDao.findObsoleteIdsBySource");
                List daos = query.setParameter("source", (Object)dataSourceID).getResultList();
                if (daos.isEmpty() && this._log.isInfoEnabled()) {
                    this._log.info((Object)("obsoleteIdIterator could not find any obsolete ids for source: " + dataSourceID));
                }
                IdIterator idIterator = new IdIterator(daos.iterator());
                return idIterator;
            }
            catch (Exception e) {
                throw new DeltaIndexingException("error executing loadRecords with source: " + dataSourceID, (Throwable)e);
            }
            finally {
                this.closeEntityManager(em);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public Iterator<Id> obsoleteIdIterator(String sessionId, Id id) throws DeltaIndexingSessionException, DeltaIndexingException {
        throw new UnsupportedOperationException("Not Implemented because working with fragments is not clear!");
    }

    public void clear() throws DeltaIndexingException {
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            try {
                try {
                    transaction.begin();
                    Query diQuery = em.createNamedQuery("DeltaIndexingDao.deleteAll");
                    diQuery.executeUpdate();
                    Query dsQuery = em.createNamedQuery("DataSourceDao.deleteSources");
                    dsQuery.executeUpdate();
                    transaction.commit();
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)"cleared delta indexing");
                    }
                }
                catch (Exception e) {
                    if (transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw new DeltaIndexingException("error clearing delta indexing", (Throwable)e);
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public void clear(String sessionId) throws DeltaIndexingSessionException, DeltaIndexingException {
        this._lock.readLock().lock();
        try {
            DataSourceDao dao = this.assertSession(sessionId);
            EntityManager em = this.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            try {
                try {
                    transaction.begin();
                    Query diQuery = em.createNamedQuery("DeltaIndexingDao.deleteBySource");
                    diQuery.setParameter("source", (Object)dao.getDataSourceId()).executeUpdate();
                    transaction.commit();
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("cleared delta indexing for sessionId: " + sessionId + " with data source " + dao.getDataSourceId()));
                    }
                }
                catch (Exception e) {
                    if (transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw new DeltaIndexingException("error clearing delta indexing for session id: " + sessionId, (Throwable)e);
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public void rollback(String sessionId) throws DeltaIndexingSessionException, DeltaIndexingException {
        throw new UnsupportedOperationException("Not Implemented yet. Use case and workflow are not specified!");
    }

    public void delete(String sessionId, Id id) throws DeltaIndexingSessionException, DeltaIndexingException {
        block12: {
            if (id == null) {
                throw new DeltaIndexingException("parameter id is null");
            }
            this._lock.readLock().lock();
            try {
                this.assertSession(sessionId, id.getSource());
                EntityManager em = this.createEntityManager();
                try {
                    DeltaIndexingDao dao = this.findDeltaIndexingDao(em, id);
                    if (dao != null) {
                        EntityTransaction transaction = em.getTransaction();
                        try {
                            transaction.begin();
                            em.remove((Object)dao);
                            transaction.commit();
                            break block12;
                        }
                        catch (Exception e) {
                            if (transaction.isActive()) {
                                transaction.rollback();
                            }
                            throw new DeltaIndexingException("error deleting id: " + id, (Throwable)e);
                        }
                    }
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("could not delete id: " + id + ". Id does not exist."));
                    }
                }
                finally {
                    this.closeEntityManager(em);
                }
            }
            finally {
                this._lock.readLock().unlock();
            }
        }
    }

    public void finish(String sessionId) throws DeltaIndexingSessionException, DeltaIndexingException {
        this._lock.readLock().lock();
        try {
            DataSourceDao dao = this.assertSession(sessionId);
            EntityManager em = this.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            try {
                try {
                    transaction.begin();
                    DataSourceDao unlockedDao = new DataSourceDao(dao.getDataSourceId(), null);
                    em.merge((Object)unlockedDao);
                    transaction.commit();
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("finished session " + sessionId + " with data source: " + dao.getDataSourceId()));
                    }
                }
                catch (Exception e) {
                    if (transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw new DeltaIndexingException("error finishing delta indexing for data source: " + dao.getDataSourceId(), (Throwable)e);
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public void unlockDatasource(String dataSourceID) throws DeltaIndexingException {
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            try {
                try {
                    transaction.begin();
                    Query query = em.createNamedQuery("DataSourceDao.killSession");
                    query.setParameter("source", (Object)dataSourceID);
                    query.executeUpdate();
                    transaction.commit();
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)("removed delta indexing sessions and unlocked data source " + dataSourceID));
                    }
                }
                catch (Exception e) {
                    if (transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw new DeltaIndexingException("error unlocking delta indexing data source " + dataSourceID, (Throwable)e);
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public void unlockDatasources() throws DeltaIndexingException {
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            try {
                try {
                    transaction.begin();
                    Query query = em.createNamedQuery("DataSourceDao.killAllSessions");
                    query.executeUpdate();
                    transaction.commit();
                    if (this._log.isInfoEnabled()) {
                        this._log.info((Object)"removed all delta indexing sessions and unlocked all data sources");
                    }
                }
                catch (Exception e) {
                    if (transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw new DeltaIndexingException("error unlocking delta indexing data sources", (Throwable)e);
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public Map<String, DeltaIndexingManager.LockState> getLockStates() {
        HashMap<String, DeltaIndexingManager.LockState> lockStates = new HashMap<String, DeltaIndexingManager.LockState>();
        this._lock.readLock().lock();
        try {
            try {
                EntityManager em = this.createEntityManager();
                try {
                    Query query = em.createNamedQuery("DataSourceDao.selectAll");
                    List list = query.getResultList();
                    for (DataSourceDao dao : list) {
                        DeltaIndexingManager.LockState state = DeltaIndexingManager.LockState.UNLOCKED;
                        if (dao.getSessionId() != null) {
                            state = DeltaIndexingManager.LockState.LOCKED;
                        }
                        lockStates.put(dao.getDataSourceId(), state);
                    }
                }
                finally {
                    this.closeEntityManager(em);
                }
            }
            catch (DeltaIndexingException ex) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"error getting lock states for all data source ids", (Throwable)ex);
                }
                this._lock.readLock().unlock();
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
        return lockStates;
    }

    public boolean exists(String dataSourceId) {
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            try {
                if (this.findDataSourceDao(em, dataSourceId) != null) {
                    this.closeEntityManager(em);
                    return true;
                }
                this.closeEntityManager(em);
                return false;
            }
            catch (Throwable throwable) {
                try {
                    this.closeEntityManager(em);
                    throw throwable;
                }
                catch (DeltaIndexingException ex) {
                    if (this._log.isErrorEnabled()) {
                        this._log.error((Object)("error checking if data source id " + dataSourceId + " exists"), (Throwable)ex);
                    }
                    return false;
                }
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public long getEntryCount(String dataSourceId) {
        this._lock.readLock().lock();
        try {
            Long count;
            EntityManager em;
            block11: {
                em = this.createEntityManager();
                try {
                    Query query = em.createNamedQuery("DeltaIndexingDao.countEntriesBySource");
                    count = (Long)query.setParameter("source", (Object)dataSourceId).getSingleResult();
                    if (count != null) break block11;
                    this.closeEntityManager(em);
                    return 0L;
                }
                catch (Throwable throwable) {
                    try {
                        this.closeEntityManager(em);
                        throw throwable;
                    }
                    catch (DeltaIndexingException ex) {
                        if (this._log.isErrorEnabled()) {
                            this._log.error((Object)("error getting entry count for data source id " + dataSourceId), (Throwable)ex);
                        }
                        return 0L;
                    }
                }
            }
            long l = count;
            this.closeEntityManager(em);
            return l;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public Map<String, Long> getEntryCounts() {
        HashMap<String, Long> entryCounts = new HashMap<String, Long>();
        this._lock.readLock().lock();
        try {
            try {
                EntityManager em = this.createEntityManager();
                try {
                    Query query = em.createNamedQuery("DeltaIndexingDao.countEntries");
                    List list = query.getResultList();
                    for (Object[] entryCount : list) {
                        entryCounts.put((String)entryCount[0], (Long)entryCount[1]);
                    }
                }
                finally {
                    this.closeEntityManager(em);
                }
            }
            catch (DeltaIndexingException ex) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"error getting entry counts for all data source ids", (Throwable)ex);
                }
                this._lock.readLock().unlock();
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
        return entryCounts;
    }

    private void assertSession(String sessionId, String dataSourceId) throws DeltaIndexingSessionException, DeltaIndexingException {
        if (sessionId == null) {
            throw new DeltaIndexingSessionException("Invalid session id: " + sessionId);
        }
        EntityManager em = this.createEntityManager();
        try {
            DataSourceDao dao = this.findDataSourceDaoBySession(em, sessionId);
            if (dao == null) {
                throw new DeltaIndexingSessionException("Invalid session id: " + sessionId);
            }
            if (!dao.getDataSourceId().equals(dataSourceId)) {
                throw new DeltaIndexingException("Invalid data source id " + dataSourceId + " for session id " + sessionId);
            }
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    private DataSourceDao assertSession(String sessionId) throws DeltaIndexingSessionException, DeltaIndexingException {
        if (sessionId == null) {
            throw new DeltaIndexingSessionException("Invalid session id: " + sessionId);
        }
        EntityManager em = this.createEntityManager();
        try {
            DataSourceDao dao = this.findDataSourceDaoBySession(em, sessionId);
            if (dao == null) {
                throw new DeltaIndexingSessionException("Invalid session id: " + sessionId);
            }
            DataSourceDao dataSourceDao = dao;
            return dataSourceDao;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    private void visitNewOrChangedDao(EntityManager em, DeltaIndexingDao dao, Id id, String hash, boolean isCompound) throws DeltaIndexingException {
        EntityTransaction transaction = em.getTransaction();
        try {
            transaction.begin();
            if (dao == null) {
                dao = new DeltaIndexingDao(id, hash, isCompound, true);
                em.persist((Object)dao);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("created and visited id: " + id));
                }
            } else {
                dao.modifyAndVisit();
                em.merge((Object)dao);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("visited Id:" + id));
                }
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new DeltaIndexingException("error visiting id: " + id, (Throwable)e);
        }
    }

    private void visitUnchangedDaos(EntityManager em, DeltaIndexingDao dao) throws DeltaIndexingException {
        Query query;
        List daos;
        dao.visit();
        em.merge((Object)dao);
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)("visited Id with hash:" + dao.getIdHash()));
        }
        if (dao.isCompound() && (daos = (query = em.createNamedQuery("DeltaIndexingDao.findSubCompounds")).setParameter("parentIdHash", (Object)dao.getIdHash()).getResultList()) != null) {
            for (DeltaIndexingDao subDao : daos) {
                this.visitUnchangedDaos(em, subDao);
            }
        }
    }

    private void resetFlags(EntityManager em, String dataSourceId) throws DeltaIndexingException {
        try {
            Query query = em.createNamedQuery("DeltaIndexingDao.resetFlags");
            query.setParameter("source", (Object)dataSourceId).executeUpdate();
            if (this._log.isInfoEnabled()) {
                this._log.info((Object)("reset visited flags for data source id: " + dataSourceId));
            }
        }
        catch (Exception e) {
            throw new DeltaIndexingException("error resetting visited flags for data source id: " + dataSourceId, (Throwable)e);
        }
    }

    private DataSourceDao findDataSourceDao(EntityManager em, String dataSourceId) {
        return (DataSourceDao)em.find(DataSourceDao.class, (Object)dataSourceId);
    }

    private DataSourceDao findDataSourceDaoBySession(EntityManager em, String sessionId) throws DeltaIndexingException {
        try {
            Query query = em.createNamedQuery("DataSourceDao.findBySessionId");
            List daos = query.setParameter("sessionId", (Object)sessionId).getResultList();
            if (daos != null && !daos.isEmpty()) {
                return (DataSourceDao)daos.get(0);
            }
            return null;
        }
        catch (Exception e) {
            throw new DeltaIndexingException("error searching for sessionId " + sessionId, (Throwable)e);
        }
    }

    private DeltaIndexingDao findDeltaIndexingDao(EntityManager em, Id id) {
        return (DeltaIndexingDao)em.find(DeltaIndexingDao.class, (Object)id.getIdHash());
    }

    private void readConfiguration() throws IOException {
        this._properties = new Properties();
        InputStream configurationFileStream = null;
        try {
            try {
                configurationFileStream = ConfigUtils.getConfigStream((String)BUNDLE_NAME, (String)CONFIGURATION_FILE);
                this._properties.load(configurationFileStream);
            }
            catch (IOException ex) {
                throw new IOException("Could not read configuration property file persistence.properties: " + ex.toString());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configurationFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)configurationFileStream);
    }

    private EntityManager createEntityManager() throws DeltaIndexingException {
        if (this._emf == null) {
            throw new DeltaIndexingException("DeltaIndexing is not active anymore. Maybe this system is shutting down?");
        }
        return this._emf.createEntityManager();
    }

    private void closeEntityManager(EntityManager em) {
        block3: {
            try {
                if (em != null) {
                    em.close();
                }
            }
            catch (Exception e) {
                if (!this._log.isErrorEnabled()) break block3;
                this._log.error((Object)"error closing local EntityManager", (Throwable)e);
            }
        }
    }
}

