/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.connectivity.impl;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.connectivity.ConnectivityException;
import org.eclipse.smila.connectivity.ConnectivityManager;
import org.eclipse.smila.connectivity.queue.worker.Operation;
import org.eclipse.smila.connectivity.queue.worker.Router;
import org.eclipse.smila.datamodel.id.Id;
import org.eclipse.smila.datamodel.record.Record;
import org.eclipse.smila.datamodel.record.RecordFactory;

public class ConnectivityManagerImpl
implements ConnectivityManager {
    private final Log _log = LogFactory.getLog(ConnectivityManagerImpl.class);
    private final RecordFactory _recordFactory = RecordFactory.DEFAULT_INSTANCE;
    private Router _router;

    public ConnectivityManagerImpl() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Creating ConnectivityManagerImpl");
        }
    }

    public void setRouterService(Router router) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Binding RouterService");
        }
        this._router = router;
    }

    public void unsetRouterService(Router router) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"Unbinding RouterService");
        }
        if (this._router == router) {
            this._router = null;
        }
    }

    public int add(Record[] records) throws ConnectivityException {
        int count = 0;
        if (records != null) {
            try {
                Map exceptionMap = this._router.route(records, Operation.ADD);
                count = records.length - exceptionMap.size();
            }
            catch (Exception e) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"Error while adding records", (Throwable)e);
                }
                throw new ConnectivityException("Error while adding records", (Throwable)e);
            }
        }
        return count;
    }

    public int delete(Id[] ids) throws ConnectivityException {
        int count = 0;
        if (ids != null) {
            Record[] records = new Record[ids.length];
            int i = 0;
            while (i < ids.length) {
                records[i] = this._recordFactory.createRecord();
                records[i].setId(ids[i]);
                ++i;
            }
            count = this.delete(records);
        }
        return count;
    }

    public int delete(Record[] records) throws ConnectivityException {
        int count = 0;
        if (records != null && records.length > 0) {
            try {
                Map exceptionMap = this._router.route(records, Operation.DELETE);
                count = records.length - exceptionMap.size();
            }
            catch (Exception e) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)"Error while deleting records", (Throwable)e);
                }
                throw new ConnectivityException("Error while deleting records", (Throwable)e);
            }
        }
        return count;
    }
}

