/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.binarystorage.persistence.jpa;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.binarystorage.BinaryStorageException;
import org.eclipse.smila.binarystorage.config.BinaryStorageConfiguration;
import org.eclipse.smila.binarystorage.persistence.BinaryPersistence;
import org.eclipse.smila.binarystorage.persistence.jpa.BinaryStorageDao;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.workspace.WorkspaceHelper;

public class JPABinaryPersistence
extends BinaryPersistence {
    public static final String BUNDLE_NAME = "org.eclipse.smila.binarystorage.persistence.jpa";
    public static final String PERSISTENCE_UNIT_NAME = "SmilaBinaryObject";
    public static final String CONFIGURATION_FILE = "persistence.properties";
    private final Log _log = LogFactory.getLog(JPABinaryPersistence.class);
    private ReadWriteLock _lock = new ReentrantReadWriteLock(true);
    private Properties _properties;
    private EntityManagerFactory _emf;

    public JPABinaryPersistence(BinaryStorageConfiguration binaryStorageConfig) throws BinaryStorageException {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"creating instance of RecordStorageImpl");
        }
        this.init(binaryStorageConfig);
    }

    public void storeBinary(String key, byte[] content) throws BinaryStorageException {
        if (key == null) {
            throw new BinaryStorageException("parameter key is null");
        }
        if (content == null) {
            throw new BinaryStorageException("parameter content is null");
        }
        this.store(new BinaryStorageDao(key, content));
    }

    public void storeBinary(String key, InputStream stream) throws BinaryStorageException {
        if (key == null) {
            throw new BinaryStorageException("parameter key is null");
        }
        if (stream == null) {
            throw new BinaryStorageException("parameter stream is null");
        }
        try {
            this.store(new BinaryStorageDao(key, stream));
        }
        catch (IOException e) {
            throw new BinaryStorageException((Throwable)e);
        }
    }

    public void deleteBinary(String key) throws BinaryStorageException {
        block12: {
            if (key == null) {
                throw new BinaryStorageException("parameter key is null");
            }
            this._lock.readLock().lock();
            try {
                EntityManager em = this.createEntityManager();
                try {
                    BinaryStorageDao dao = this.findBinaryStorageDao(em, key);
                    if (dao != null) {
                        EntityTransaction transaction = em.getTransaction();
                        try {
                            transaction.begin();
                            em.remove((Object)dao);
                            transaction.commit();
                            break block12;
                        }
                        catch (Exception e) {
                            if (transaction.isActive()) {
                                transaction.rollback();
                            }
                            throw new BinaryStorageException((Throwable)e, "error removing record id: " + key);
                        }
                    }
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("could not remove id: " + key + ". no binary object with this id exists."));
                    }
                }
                finally {
                    this.closeEntityManager(em);
                }
            }
            finally {
                this._lock.readLock().unlock();
            }
        }
    }

    public long fetchSize(String key) throws BinaryStorageException {
        if (key == null) {
            throw new BinaryStorageException("parameter key is null");
        }
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            try {
                BinaryStorageDao dao = this.findBinaryStorageDao(em, key);
                if (dao != null) {
                    long l = dao.getBytes().length;
                    return l;
                }
                throw new BinaryStorageException("could not fetch size for id: " + key + ". no binary object with this id exists.");
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    public byte[] loadBinaryAsByteArray(String key) throws BinaryStorageException {
        return this.load(key).getBytes();
    }

    public InputStream loadBinaryAsInputStream(String key) throws BinaryStorageException {
        return this.load(key).getBytesAsStream();
    }

    public void cleanup() throws BinaryStorageException {
        this._lock.writeLock().lock();
        try {
            block8: {
                try {
                    if (this._emf != null) {
                        this._emf.close();
                    }
                }
                catch (Exception e) {
                    if (!this._log.isErrorEnabled()) break block8;
                    this._log.error((Object)"error closing EntityManagerFactory", (Throwable)e);
                }
            }
            this._emf = null;
            if (this._properties != null) {
                this._properties.clear();
                this._properties = null;
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)"deactivated RecordStorageImpl service");
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    private void init(BinaryStorageConfiguration binaryStorageConfig) throws BinaryStorageException {
        EntityManager em = null;
        try {
            try {
                this.readConfiguration();
                if (!this._properties.containsKey("eclipselink.logging.file")) {
                    File workingDir = WorkspaceHelper.createWorkingDir((String)BUNDLE_NAME);
                    File logfile = new File(workingDir, "jpa.log");
                    this._properties.put("eclipselink.logging.file", logfile.getAbsolutePath());
                }
                this._emf = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, (Map)this._properties);
                em = this._emf.createEntityManager();
            }
            catch (Exception e) {
                throw new BinaryStorageException("error activating JPABinaryPersistence", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.closeEntityManager(em);
            throw throwable;
        }
        this.closeEntityManager(em);
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)"started JPABinaryPersistence");
        }
    }

    private BinaryStorageDao load(String key) throws BinaryStorageException {
        if (key == null) {
            throw new BinaryStorageException("parameter key is null");
        }
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            try {
                BinaryStorageDao dao = this.findBinaryStorageDao(em, key);
                if (dao != null) {
                    BinaryStorageDao binaryStorageDao = dao;
                    return binaryStorageDao;
                }
                throw new BinaryStorageException("error loading id: " + key + ". no binary object with this id exists.");
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    private synchronized void store(BinaryStorageDao dao) throws BinaryStorageException {
        this._lock.readLock().lock();
        try {
            EntityManager em = this.createEntityManager();
            EntityTransaction transaction = em.getTransaction();
            try {
                try {
                    transaction.begin();
                    if (this.findBinaryStorageDao(em, dao.getId()) == null) {
                        em.persist((Object)dao);
                    } else {
                        em.merge((Object)dao);
                    }
                    transaction.commit();
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)("stored content of id:" + dao.getId()));
                    }
                }
                catch (Exception e) {
                    if (transaction.isActive()) {
                        transaction.rollback();
                    }
                    throw new BinaryStorageException((Throwable)e, "error storing record id: " + dao.getId());
                }
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    private BinaryStorageDao findBinaryStorageDao(EntityManager em, String id) {
        return (BinaryStorageDao)em.find(BinaryStorageDao.class, (Object)id);
    }

    private void readConfiguration() throws IOException {
        this._properties = new Properties();
        InputStream configurationFileStream = null;
        try {
            try {
                configurationFileStream = ConfigUtils.getConfigStream((String)BUNDLE_NAME, (String)CONFIGURATION_FILE);
                this._properties.load(configurationFileStream);
            }
            catch (IOException ex) {
                throw new IOException("Could not read configuration property file persistence.properties: " + ex.toString());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(configurationFileStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)configurationFileStream);
    }

    private EntityManager createEntityManager() throws BinaryStorageException {
        if (this._emf == null) {
            throw new BinaryStorageException("BinaryStorage PJA Persistence is not active anymore. Maybe this system is shutting down?");
        }
        return this._emf.createEntityManager();
    }

    private void closeEntityManager(EntityManager em) {
        block3: {
            try {
                if (em != null) {
                    em.close();
                }
            }
            catch (Exception e) {
                if (!this._log.isErrorEnabled()) break block3;
                this._log.error((Object)"error closing local EntityManager", (Throwable)e);
            }
        }
    }
}

